/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.maven.plugin;

import com.contrastsecurity.maven.plugin.AbstractContrastMavenPluginMojo;
import com.contrastsecurity.sdk.ContrastSDK;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="install", defaultPhase=LifecyclePhase.VALIDATE, requiresOnline=true)
public class InstallAgentContrastMavenMojo
extends AbstractContrastMavenPluginMojo {
    String applicationName;
    static Map<String, String> environmentToSessionMetadata = new TreeMap<String, String>();

    public void execute() throws MojoExecutionException {
        this.verifyAppIdOrNameNotBlank();
        this.getLog().info((CharSequence)"Attempting to connect to configured TeamServer...");
        ContrastSDK contrast = this.connectToTeamServer();
        this.getLog().info((CharSequence)"Successfully authenticated to Teamserver. Attempting to install the Java agent.");
        File agentFile = this.installJavaAgent(contrast);
        this.getLog().info((CharSequence)"Agent downloaded.");
        if (StringUtils.isNotBlank((String)this.appId)) {
            this.applicationName = this.getAppName(contrast, this.appId);
            if (StringUtils.isNotBlank((String)this.appName)) {
                this.getLog().info((CharSequence)"Using 'appId' property; 'appName' property is ignored.");
            }
        } else {
            this.applicationName = this.appName;
        }
        this.project.getProperties().setProperty("argLine", this.buildArgLine(this.project.getProperties().getProperty("argLine"), this.applicationName));
    }

    public String computeAppVersion(Date currentDate) {
        if (computedAppVersion != null) {
            return computedAppVersion;
        }
        if (this.appVersion != null) {
            this.getLog().info((CharSequence)("Using user-specified app version [" + this.appVersion + "]"));
            computedAppVersion = this.appVersion;
            return computedAppVersion;
        }
        String travisBuildNumber = System.getenv("TRAVIS_BUILD_NUMBER");
        String circleBuildNum = System.getenv("CIRCLE_BUILD_NUM");
        String appVersionQualifier = "";
        if (travisBuildNumber != null) {
            this.getLog().info((CharSequence)("Build is running in TravisCI. We'll use TRAVIS_BUILD_NUMBER [" + travisBuildNumber + "]"));
            appVersionQualifier = travisBuildNumber;
        } else if (circleBuildNum != null) {
            this.getLog().info((CharSequence)("Build is running in CircleCI. We'll use CIRCLE_BUILD_NUM [" + circleBuildNum + "]"));
            appVersionQualifier = circleBuildNum;
        } else {
            this.getLog().info((CharSequence)"No CI build number detected, we'll use current timestamp.");
            appVersionQualifier = new SimpleDateFormat("yyyyMMddHHmmss").format(currentDate);
        }
        computedAppVersion = StringUtils.isNotBlank((String)this.appId) ? this.applicationName + "-" + appVersionQualifier : this.appName + "-" + appVersionQualifier;
        return computedAppVersion;
    }

    public String computeSessionMetadata() {
        ArrayList<String> metadata = new ArrayList<String>();
        for (Map.Entry<String, String> entry : environmentToSessionMetadata.entrySet()) {
            String environmentValue = System.getenv(entry.getKey());
            if (environmentValue == null) continue;
            metadata.add(String.format("%s=%s", entry.getValue(), environmentValue));
        }
        return StringUtils.join(metadata, (String)",");
    }

    public String buildArgLine(String currentArgLine) {
        return this.buildArgLine(currentArgLine, this.appName);
    }

    public String buildArgLine(String currentArgLine, String applicationName) {
        if (currentArgLine == null) {
            this.getLog().info((CharSequence)"Current argLine is null");
            currentArgLine = "";
        } else {
            this.getLog().info((CharSequence)("Current argLine is [" + currentArgLine + "]"));
        }
        if (this.skipArgLine) {
            this.getLog().info((CharSequence)"skipArgLine is set to false.");
            this.getLog().info((CharSequence)"You will need to configure the Maven argLine property manually for the Contrast agent to work.");
            return currentArgLine;
        }
        this.getLog().info((CharSequence)"Configuring argLine property.");
        computedAppVersion = this.computeAppVersion(new Date());
        StringBuilder argLineBuilder = new StringBuilder();
        argLineBuilder.append(currentArgLine);
        argLineBuilder.append(" -javaagent:").append(this.contrastAgentLocation);
        argLineBuilder.append(" -Dcontrast.server=").append(this.serverName);
        argLineBuilder.append(" -Dcontrast.env=qa");
        argLineBuilder.append(" -Dcontrast.override.appversion=").append(computedAppVersion);
        argLineBuilder.append(" -Dcontrast.reporting.period=").append("200");
        String sessionMetadata = this.computeSessionMetadata();
        if (!sessionMetadata.isEmpty()) {
            argLineBuilder.append(" -Dcontrast.application.session_metadata='").append(sessionMetadata).append("'");
        }
        if (this.standalone) {
            argLineBuilder.append(" -Dcontrast.standalone.appname=").append(applicationName);
        } else {
            argLineBuilder.append(" -Dcontrast.override.appname=").append(applicationName);
        }
        if (!StringUtils.isEmpty((String)this.serverPath)) {
            argLineBuilder.append(" -Dcontrast.path=").append(this.serverPath);
        }
        String newArgLine = argLineBuilder.toString();
        this.getLog().info((CharSequence)("Updated argLine is " + newArgLine));
        return newArgLine.trim();
    }

    static {
        environmentToSessionMetadata.put("GIT_BRANCH", "branchName");
        environmentToSessionMetadata.put("GIT_COMMITTER_NAME", "committer");
        environmentToSessionMetadata.put("GIT_COMMIT", "commitHash");
        environmentToSessionMetadata.put("GIT_URL", "repository");
        environmentToSessionMetadata.put("GIT_URL_1", "repository");
        environmentToSessionMetadata.put("BUILD_NUMBER", "buildNumber");
        environmentToSessionMetadata.put("TRAVIS_BUILD_NUMBER", "buildNumber");
        environmentToSessionMetadata.put("CIRCLE_BUILD_NUM", "buildNumber");
    }
}

