/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.maven.plugin;

import com.contrastsecurity.exceptions.UnauthorizedException;
import com.contrastsecurity.models.AgentType;
import com.contrastsecurity.models.Applications;
import com.contrastsecurity.sdk.ContrastSDK;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

abstract class AbstractContrastMavenPluginMojo
extends AbstractMojo {
    @Component
    protected MavenProject project;
    @Component
    protected Settings settings;
    @Parameter(property="username", required=true)
    protected String username;
    @Parameter(property="apiKey", required=true)
    protected String apiKey;
    @Parameter(property="serviceKey", required=true)
    protected String serviceKey;
    @Parameter(property="apiUrl")
    protected String apiUrl;
    @Parameter(property="orgUuid", required=true)
    protected String orgUuid;
    @Parameter(property="appName")
    protected String appName;
    @Parameter(property="appId")
    protected String appId;
    @Parameter(property="standalone")
    protected boolean standalone;
    @Parameter(property="minSeverity", defaultValue="Medium")
    protected String minSeverity;
    @Parameter(property="serverName", required=true)
    protected String serverName;
    @Parameter(property="serverPath")
    protected String serverPath;
    @Parameter(property="jarPath")
    protected String jarPath;
    @Parameter(property="profile")
    protected String profile;
    @Parameter(property="appVersion")
    protected String appVersion;
    @Parameter(property="skipArgLine")
    protected boolean skipArgLine;
    protected String contrastAgentLocation;
    protected static String computedAppVersion;
    private static final String AGENT_NAME = "contrast.jar";

    AbstractContrastMavenPluginMojo() {
    }

    public void execute() throws MojoExecutionException {
    }

    ContrastSDK connectToTeamServer() throws MojoExecutionException {
        Proxy proxy = Proxy.NO_PROXY;
        final org.apache.maven.settings.Proxy proxySettings = this.settings.getActiveProxy();
        if (proxySettings != null) {
            this.getLog().debug((CharSequence)String.format("Using a proxy %s:%s", proxySettings.getHost(), proxySettings.getPort()));
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxySettings.getHost(), proxySettings.getPort()));
            if (proxySettings.getUsername() != null || proxySettings.getPassword() != null) {
                Authenticator.setDefault(new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        if (this.getRequestorType() == Authenticator.RequestorType.PROXY && this.getRequestingHost().equalsIgnoreCase(proxySettings.getHost()) && proxySettings.getPort() == this.getRequestingPort()) {
                            return new PasswordAuthentication(proxySettings.getUsername(), proxySettings.getPassword() == null ? null : proxySettings.getPassword().toCharArray());
                        }
                        return null;
                    }
                });
            }
        }
        try {
            if (!StringUtils.isEmpty((String)this.apiUrl)) {
                return new ContrastSDK.Builder(this.username, this.serviceKey, this.apiKey).withApiUrl(this.apiUrl).withProxy(proxy).build();
            }
            return new ContrastSDK.Builder(this.username, this.serviceKey, this.apiKey).withProxy(proxy).build();
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException("\n\nWe couldn't connect to TeamServer at this address [" + this.apiUrl + "]. The error is: ", (Exception)e);
        }
    }

    String getAppName(ContrastSDK contrastSDK, String applicationId) throws MojoExecutionException {
        Applications applications;
        try {
            applications = contrastSDK.getApplication(this.orgUuid, applicationId);
        }
        catch (Exception e) {
            String logMessage = e.getMessage().contains("403") ? "\n\n Unable to find the application on TeamServer with the id [" + applicationId + "]\n" : "\n\n Unable to retrieve the application list from TeamServer. Please check that TeamServer is running at this address [" + this.apiUrl + "]\n";
            throw new MojoExecutionException(logMessage, e);
        }
        if (applications.getApplication() == null) {
            throw new MojoExecutionException("\n\nApplication with id '" + applicationId + "' not found. Make sure this application appears in TeamServer under the 'Applications' tab.\n");
        }
        return applications.getApplication().getName();
    }

    void verifyAppIdOrNameNotBlank() throws MojoExecutionException {
        if (StringUtils.isBlank((String)this.appId) && StringUtils.isBlank((String)this.appName)) {
            throw new MojoExecutionException("Please specify appId or appName in the plugin configuration.");
        }
    }

    File installJavaAgent(ContrastSDK connection) throws MojoExecutionException {
        File agentFile;
        if (StringUtils.isEmpty((String)this.jarPath)) {
            byte[] javaAgent;
            this.getLog().info((CharSequence)"No jar path was configured. Downloading the latest contrast.jar...");
            try {
                javaAgent = this.profile != null ? connection.getAgent(AgentType.JAVA, this.orgUuid, this.profile) : connection.getAgent(AgentType.JAVA, this.orgUuid);
            }
            catch (IOException e) {
                throw new MojoExecutionException("\n\nWe couldn't download the Java agent from TeamServer with this user [" + this.username + "]. Please check that all your credentials are correct. If everything is correct, please contact Contrast Support. The error is:", (Exception)e);
            }
            catch (UnauthorizedException e) {
                throw new MojoExecutionException("\n\nWe contacted TeamServer successfully but couldn't authorize with the credentials you provided. The error is:", (Exception)((Object)e));
            }
            agentFile = new File(this.project.getBuild().getDirectory() + File.separator + AGENT_NAME);
            try {
                FileUtils.writeByteArrayToFile((File)agentFile, (byte[])javaAgent);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to save the latest java agent.", (Exception)e);
            }
            this.getLog().info((CharSequence)("Saved the latest java agent to " + agentFile.getAbsolutePath()));
            this.contrastAgentLocation = agentFile.getAbsolutePath();
        } else {
            this.getLog().info((CharSequence)("Using configured jar path " + this.jarPath));
            agentFile = new File(this.jarPath);
            if (!agentFile.exists()) {
                throw new MojoExecutionException("Unable to load the local Java agent from " + this.jarPath);
            }
            this.getLog().info((CharSequence)("Loaded the latest java agent from " + this.jarPath));
            this.contrastAgentLocation = this.jarPath;
        }
        return agentFile;
    }
}

