/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.maven.plugin;

import com.contrastsecurity.exceptions.UnauthorizedException;
import com.contrastsecurity.http.RuleSeverity;
import com.contrastsecurity.http.ServerFilterForm;
import com.contrastsecurity.http.TraceFilterForm;
import com.contrastsecurity.maven.plugin.AbstractContrastMavenPluginMojo;
import com.contrastsecurity.models.Application;
import com.contrastsecurity.models.Applications;
import com.contrastsecurity.models.Server;
import com.contrastsecurity.models.Servers;
import com.contrastsecurity.models.Trace;
import com.contrastsecurity.models.Traces;
import com.contrastsecurity.sdk.ContrastSDK;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="verify", requiresOnline=true)
public class VerifyContrastMavenPluginMojo
extends AbstractContrastMavenPluginMojo {
    private static final List<String> SEVERITIES = Arrays.asList("Note", "Low", "Medium", "High", "Critical");

    @Override
    public void execute() throws MojoExecutionException {
        Traces traces;
        ContrastSDK contrast = this.connectToTeamServer();
        this.getLog().info((CharSequence)"Successfully authenticated to TeamServer.");
        this.getLog().info((CharSequence)("Checking for new vulnerabilities for appVersion [" + computedAppVersion + "]"));
        String applicationId = this.getApplicationId(contrast, this.appName);
        long serverId = this.getServerId(contrast, applicationId);
        TraceFilterForm form = new TraceFilterForm();
        form.setSeverities(VerifyContrastMavenPluginMojo.getSeverityList(this.minSeverity));
        form.setAppVersionTags(Collections.singletonList(computedAppVersion));
        form.setServerIds(Arrays.asList(serverId));
        this.getLog().info((CharSequence)"Sending vulnerability request to TeamServer.");
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            traces = contrast.getTraces(this.orgUuid, applicationId, form);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to retrieve the traces.", (Exception)e);
        }
        catch (UnauthorizedException e) {
            throw new MojoExecutionException("Unable to connect to TeamServer.", (Exception)((Object)e));
        }
        if (traces != null && traces.getCount() > 0) {
            this.getLog().info((CharSequence)(traces.getCount() + " new vulnerability(s) were found. Printing vulnerability report."));
            for (Trace trace : traces.getTraces()) {
                this.getLog().info((CharSequence)this.generateTraceReport(trace));
            }
            throw new MojoExecutionException("Your application is vulnerable. Please see the above report for new vulnerabilities.");
        }
        this.getLog().info((CharSequence)"No new vulnerabilities were found.");
        this.getLog().info((CharSequence)"Finished verifying your application.");
    }

    private long getServerId(ContrastSDK sdk, String applicationId) throws MojoExecutionException {
        Servers servers;
        ServerFilterForm serverFilterForm = new ServerFilterForm();
        serverFilterForm.setApplicationIds(Arrays.asList(applicationId));
        serverFilterForm.setQ(this.serverName);
        try {
            servers = sdk.getServersWithFilter(this.orgUuid, serverFilterForm);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to retrieve the servers.", (Exception)e);
        }
        catch (UnauthorizedException e) {
            throw new MojoExecutionException("Unable to connect to TeamServer.", (Exception)((Object)e));
        }
        if (servers.getServers().isEmpty()) {
            throw new MojoExecutionException("\n\nServer with name '" + this.serverName + "' not found. Make sure this server name appears in TeamServer under the 'Servers' tab.\n");
        }
        long serverId = ((Server)servers.getServers().get(0)).getServerId();
        return serverId;
    }

    private String getApplicationId(ContrastSDK sdk, String applicationName) throws MojoExecutionException {
        Applications applications;
        try {
            applications = sdk.getApplications(this.orgUuid);
        }
        catch (Exception e) {
            throw new MojoExecutionException("\n\nUnable to retrieve the application list from TeamServer. Please check that TeamServer is running at this address [" + this.apiUrl + "]\n", e);
        }
        for (Application application : applications.getApplications()) {
            if (!applicationName.equals(application.getName())) continue;
            return application.getId();
        }
        throw new MojoExecutionException("\n\nApplication with name '" + applicationName + "' not found. Make sure this server name appears in TeamServer under the 'Applications' tab.\n");
    }

    private String generateTraceReport(Trace trace) {
        StringBuilder sb = new StringBuilder();
        sb.append("Trace: ");
        sb.append(trace.getTitle().replaceAll("\\{\\{\\#unlicensed\\}\\}", "(").replaceAll("\\{\\{\\/unlicensed\\}\\}", ")"));
        sb.append("\nTrace Uuid: ");
        sb.append(trace.getUuid());
        sb.append("\nTrace Severity: ");
        sb.append(trace.getSeverity());
        sb.append("\nTrace Likelihood: ");
        sb.append(trace.getLikelihood());
        sb.append("\n");
        return sb.toString();
    }

    private static EnumSet<RuleSeverity> getSeverityList(String severity) {
        List<String> severityList = SEVERITIES.subList(SEVERITIES.indexOf(severity), SEVERITIES.size());
        ArrayList<RuleSeverity> ruleSeverities = new ArrayList<RuleSeverity>();
        for (String severityToAdd : severityList) {
            ruleSeverities.add(RuleSeverity.valueOf((String)severityToAdd.toUpperCase()));
        }
        return EnumSet.copyOf(ruleSeverities);
    }
}

