/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.maven.plugin;

import com.contrastsecurity.exceptions.UnauthorizedException;
import com.contrastsecurity.models.AgentType;
import com.contrastsecurity.sdk.ContrastSDK;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

abstract class AbstractContrastMavenPluginMojo
extends AbstractMojo {
    @Component
    protected MavenProject project;
    @Parameter(property="username", required=true)
    protected String username;
    @Parameter(property="apiKey", required=true)
    protected String apiKey;
    @Parameter(property="serviceKey", required=true)
    protected String serviceKey;
    @Parameter(property="apiUrl")
    protected String apiUrl;
    @Parameter(property="orgUuid", required=true)
    protected String orgUuid;
    @Parameter(property="appName", required=true)
    protected String appName;
    @Parameter(property="standalone")
    protected boolean standalone;
    @Parameter(property="minSeverity", defaultValue="Medium")
    protected String minSeverity;
    @Parameter(property="serverName", required=true)
    protected String serverName;
    @Parameter(property="serverPath")
    protected String serverPath;
    @Parameter(property="jarPath")
    protected String jarPath;
    @Parameter(property="profile")
    protected String profile;
    @Parameter(property="appVersion")
    protected String appVersion;
    @Parameter(property="skipArgLine")
    protected boolean skipArgLine;
    protected String contrastAgentLocation;
    protected static String computedAppVersion;
    private static final String AGENT_NAME = "contrast.jar";

    AbstractContrastMavenPluginMojo() {
    }

    public void execute() throws MojoExecutionException {
    }

    ContrastSDK connectToTeamServer() throws MojoExecutionException {
        try {
            if (!StringUtils.isEmpty((String)this.apiUrl)) {
                return new ContrastSDK(this.username, this.serviceKey, this.apiKey, this.apiUrl);
            }
            return new ContrastSDK(this.username, this.serviceKey, this.apiKey);
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException("\n\nWe couldn't connect to TeamServer at this address [" + this.apiUrl + "]. The error is: ", (Exception)e);
        }
    }

    File installJavaAgent(ContrastSDK connection) throws MojoExecutionException {
        File agentFile;
        if (StringUtils.isEmpty((String)this.jarPath)) {
            byte[] javaAgent;
            this.getLog().info((CharSequence)"No jar path was configured. Downloading the latest contrast.jar...");
            try {
                javaAgent = this.profile != null ? connection.getAgent(AgentType.JAVA, this.orgUuid, this.profile) : connection.getAgent(AgentType.JAVA, this.orgUuid);
            }
            catch (IOException e) {
                throw new MojoExecutionException("\n\nWe couldn't download the Java agent from TeamServer with this user [" + this.username + "]. Please check that all your credentials are correct. If everything is correct, please contact Contrast Support. The error is:", (Exception)e);
            }
            catch (UnauthorizedException e) {
                throw new MojoExecutionException("\n\nWe contacted TeamServer successfully but couldn't authorize with the credentials you provided. The error is:", (Exception)((Object)e));
            }
            agentFile = new File(this.project.getBuild().getDirectory() + File.separator + AGENT_NAME);
            try {
                FileUtils.writeByteArrayToFile((File)agentFile, (byte[])javaAgent);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to save the latest java agent.", (Exception)e);
            }
            this.getLog().info((CharSequence)("Saved the latest java agent to " + agentFile.getAbsolutePath()));
            this.contrastAgentLocation = agentFile.getAbsolutePath();
        } else {
            this.getLog().info((CharSequence)("Using configured jar path " + this.jarPath));
            agentFile = new File(this.jarPath);
            if (!agentFile.exists()) {
                throw new MojoExecutionException("Unable to load the local Java agent from " + this.jarPath);
            }
            this.getLog().info((CharSequence)("Loaded the latest java agent from " + this.jarPath));
            this.contrastAgentLocation = this.jarPath;
        }
        return agentFile;
    }
}

