/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.TestAction;
import com.consol.citrus.actions.ReceiveMessageAction;
import com.consol.citrus.dsl.actions.DelegatingTestAction;
import com.consol.citrus.dsl.builder.ReceiveMessageBuilder;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.http.message.HttpMessageContentBuilder;
import com.consol.citrus.http.message.HttpMessageUtils;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.validation.builder.AbstractMessageContentBuilder;
import com.consol.citrus.validation.builder.MessageContentBuilder;
import com.consol.citrus.validation.builder.StaticMessageContentBuilder;
import javax.servlet.http.Cookie;
import org.springframework.http.HttpStatus;

public class HttpClientResponseActionBuilder
extends ReceiveMessageBuilder<ReceiveMessageAction, HttpClientResponseActionBuilder> {
    private HttpMessage httpMessage = new HttpMessage();

    public HttpClientResponseActionBuilder(DelegatingTestAction<TestAction> delegate, Endpoint httpClient) {
        super(delegate);
        delegate.setDelegate((TestAction)new ReceiveMessageAction());
        this.getAction().setEndpoint(httpClient);
        this.initMessage(this.httpMessage);
        this.messageType(MessageType.XML);
        this.headerNameIgnoreCase(true);
    }

    public HttpClientResponseActionBuilder(DelegatingTestAction<TestAction> delegate, String httpClientUri) {
        super(delegate);
        delegate.setDelegate((TestAction)new ReceiveMessageAction());
        this.getAction().setEndpointUri(httpClientUri);
        this.initMessage(this.httpMessage);
        this.messageType(MessageType.XML);
        this.headerNameIgnoreCase(true);
    }

    private void initMessage(HttpMessage message) {
        StaticMessageContentBuilder staticMessageContentBuilder = StaticMessageContentBuilder.withMessage((Message)message);
        staticMessageContentBuilder.setMessageHeaders(message.getHeaders());
        this.getAction().setMessageBuilder((MessageContentBuilder)new HttpMessageContentBuilder(message, (AbstractMessageContentBuilder)staticMessageContentBuilder));
    }

    @Override
    protected void setPayload(String payload) {
        this.httpMessage.setPayload((Object)payload);
    }

    @Override
    public HttpClientResponseActionBuilder name(String name) {
        this.httpMessage.setName(name);
        return (HttpClientResponseActionBuilder)super.name(name);
    }

    public HttpClientResponseActionBuilder status(HttpStatus status) {
        this.httpMessage.status(status);
        return this;
    }

    public HttpClientResponseActionBuilder statusCode(Integer statusCode) {
        this.httpMessage.statusCode(statusCode);
        return this;
    }

    public HttpClientResponseActionBuilder reasonPhrase(String reasonPhrase) {
        this.httpMessage.reasonPhrase(reasonPhrase);
        return this;
    }

    public HttpClientResponseActionBuilder version(String version) {
        this.httpMessage.version(version);
        return this;
    }

    public HttpClientResponseActionBuilder contentType(String contentType) {
        this.httpMessage.contentType(contentType);
        return this;
    }

    public HttpClientResponseActionBuilder cookie(Cookie cookie) {
        this.httpMessage.cookie(cookie);
        return this;
    }

    @Override
    public HttpClientResponseActionBuilder message(Message message) {
        HttpMessageUtils.copy((Message)message, (HttpMessage)this.httpMessage);
        return this;
    }
}

