/*
 * Decompiled with CFR 0.152.
 */
package com.comscore.util;

import android.os.Looper;
import com.comscore.util.log.Logger;
import com.comscore.util.setup.Setup;

public class CrossPublisherIdUtil {
    private static native void requestCrossPublisherIdNative(Listener var0);

    private static native String getGeneratedCrossPublisherUniqueDeviceIdNative();

    private static native String getMD5CrossPublisherDeviceIdNative();

    public static void requestCrossPublisherId(Listener listener) {
        if (!Setup.isSetUpFinished()) {
            Logger.e("Library not initialised. Unable to retrieve the crosspublisher ID");
            return;
        }
        try {
            CrossPublisherIdUtil.requestCrossPublisherIdNative(listener);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Logger.e("Error using the native library: ", unsatisfiedLinkError);
        }
    }

    public static GeneratedCrossPublisherId getGeneratedCrossPublisherDeviceId() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            GeneratedCrossPublisherId generatedCrossPublisherId;
            String string;
            String string2;
            if (!Setup.isSetUpFinished()) {
                Logger.e("Library not initialised. Unable to retrieve the crosspublisher ID");
                return null;
            }
            try {
                String string3 = CrossPublisherIdUtil.getGeneratedCrossPublisherUniqueDeviceIdNative();
                string2 = string3;
                string = string3;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Logger.e("Error using the native library: ", unsatisfiedLinkError);
                return null;
            }
            String string4 = string2.substring(2);
            boolean bl = string.charAt(0) == '1';
            GeneratedCrossPublisherId generatedCrossPublisherId2 = generatedCrossPublisherId;
            generatedCrossPublisherId2(string4, bl);
            return generatedCrossPublisherId2;
        }
        throw new IllegalStateException("Cannot be called from the main thread");
    }

    public static String getMD5CrossPublisherDeviceId() {
        if (!Setup.isSetUpFinished()) {
            Logger.e("Library not initialised. Unable to retrieve the MD5 crosspublisher ID");
            return null;
        }
        try {
            return CrossPublisherIdUtil.getMD5CrossPublisherDeviceIdNative();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Logger.e("Error using the native library: ", unsatisfiedLinkError);
            return null;
        }
    }

    public static interface Listener {
        public void onCrossPublisherIdRequested(String var1, boolean var2);
    }

    public static class GeneratedCrossPublisherId {
        private String a;
        private boolean b;

        GeneratedCrossPublisherId(String string, boolean bl) {
            this.a = string;
            this.b = bl;
        }

        public String getValue() {
            return this.a;
        }

        public boolean isChanged() {
            return this.b;
        }
    }
}

