/*
 * Decompiled with CFR 0.152.
 */
package com.compilit.logging;

import com.compilit.logging.MethodExecution;
import com.compilit.logging.MethodPhase;
import com.compilit.logging.api.Event;
import com.compilit.logging.api.Log;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;

class OnResultMethodPhase
extends MethodPhase {
    OnResultMethodPhase() {
    }

    @Override
    void next(ProceedingJoinPoint joinPoint, Logger logger, List<Log> logEntries, MethodExecution methodExecution) {
        try {
            String methodName = this.getMethodName(joinPoint);
            Object result = joinPoint.proceed();
            if (OnResultMethodPhase.containsEvent(logEntries, Event.ON_RESULT)) {
                Log logAnnotation = OnResultMethodPhase.getLogAnnotation(logEntries, Event.ON_RESULT);
                OnResultMethodPhase.log(logger, OnResultMethodPhase.getMessage(logAnnotation.message(), logAnnotation.event()), logAnnotation.level(), methodName, result);
            }
            methodExecution.setExecutionResult(result);
        }
        catch (Throwable e) {
            methodExecution.setException(e);
        }
    }
}

