/*
 * Decompiled with CFR 0.152.
 */
package com.compilit.logging;

import com.compilit.logging.MethodExecution;
import com.compilit.logging.MethodPhase;
import com.compilit.logging.api.Event;
import com.compilit.logging.api.Log;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.event.Level;

final class OnExceptionMethodPhase
extends MethodPhase {
    OnExceptionMethodPhase() {
    }

    @Override
    void next(ProceedingJoinPoint joinPoint, Logger logger, List<Log> logEntries, MethodExecution methodExecution) {
        String methodName = this.getMethodName(joinPoint);
        if (OnExceptionMethodPhase.containsEvent(logEntries, Event.ON_EXCEPTION) && methodExecution.isExceptionThrown()) {
            Log logAnnotation = OnExceptionMethodPhase.getLogAnnotation(logEntries, Event.ON_EXCEPTION);
            Throwable stackTrace = methodExecution.isLogStackTraces() ? methodExecution.getException() : null;
            OnExceptionMethodPhase.log(logger, OnExceptionMethodPhase.getMessage(logAnnotation.message(), logAnnotation.event()), Level.ERROR, methodName, methodExecution.getException().getClass(), stackTrace);
        }
    }
}

