/*
 * Decompiled with CFR 0.152.
 */
package com.compilit.logging;

import com.compilit.logging.MethodExecution;
import com.compilit.logging.MethodPhase;
import com.compilit.logging.api.Event;
import com.compilit.logging.api.Log;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;

final class OnCallMethodPhase
extends MethodPhase {
    OnCallMethodPhase() {
    }

    @Override
    void next(ProceedingJoinPoint joinPoint, Logger logger, List<Log> logEntries, MethodExecution methodExecution) {
        String methodName = this.getMethodName(joinPoint);
        if (OnCallMethodPhase.containsEvent(logEntries, Event.ON_CALLED) && joinPoint.getArgs().length > 0) {
            Log logAnnotation = OnCallMethodPhase.getLogAnnotation(logEntries, Event.ON_CALLED);
            String argumentsMessage = OnCallMethodPhase.createArgumentsMessage(joinPoint, logAnnotation);
            Object[] varargs = new Object[joinPoint.getArgs().length + 1];
            System.arraycopy(joinPoint.getArgs(), 0, varargs, 1, varargs.length - 1);
            varargs[0] = methodName;
            OnCallMethodPhase.log(logger, argumentsMessage, logAnnotation.level(), varargs);
        }
    }

    private static String createArgumentsMessage(ProceedingJoinPoint joinPoint, Log logAnnotation) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(OnCallMethodPhase.getMessage(logAnnotation.message(), logAnnotation.event()));
        for (int index = 0; index < joinPoint.getArgs().length; ++index) {
            Object argument = joinPoint.getArgs()[index];
            stringBuilder.append(String.format("[%s (%s)]: {} ", index, argument.getClass()));
        }
        return stringBuilder.toString();
    }
}

