package com.compilit.logging;

import com.compilit.logging.api.Log;
import com.compilit.logging.api.Logged;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

@Component
final class MethodPhaseChainBuilder {

  private final List<MethodPhase> methodPhases = new ArrayList<>();
  private boolean shouldRethrowExceptions;
  private boolean shouldLogStackTraces;

  MethodPhaseChainBuilder addPhase(MethodPhase methodPhase) {
    methodPhases.add(methodPhase);
    return this;
  }

  Object process(ProceedingJoinPoint joinPoint, Logger logger, List<Log> logEntries, Logged annotation) throws Throwable {
    var methodExecution = new MethodExecution(annotation.logStackTraces() && shouldLogStackTraces);
    methodPhases.forEach(entry -> entry.next(joinPoint, logger, logEntries, methodExecution));
    if (methodExecution.isExceptionThrown() && (annotation.rethrow() && shouldRethrowExceptions)) {
        throw methodExecution.getException();
    }
    return methodExecution.getExecutionResult();
  }

  MethodPhaseChainBuilder configure(LoggingConfiguration loggingConfiguration) {
    this.shouldRethrowExceptions = loggingConfiguration.isRethrowExceptions();
    this.shouldLogStackTraces = loggingConfiguration.isLogStackTraces();
    return this;
  }
}
