/*
 * Decompiled with CFR 0.152.
 */
package com.comoyo.logging.context.json;

import com.comoyo.commons.logging.context.LoggingContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;

public class JsonEventFormatter
extends Formatter {
    public static final String JSON_KEY_VERSION = "@version";
    public static final String JSON_KEY_TIMESTAMP = "@timestamp";
    public static final String JSON_KEY_LEVEL = "level";
    public static final String JSON_KEY_MESSAGE = "message";
    public static final String JSON_KEY_SOURCE = "source";
    public static final String JSON_KEY_SOURCE_HOST = "source_host";
    public static final String JSON_KEY_LOGGER_NAME = "logger_name";
    public static final String JSON_KEY_SOURCE_METHOD = "source_method";
    public static final String JSON_KEY_SOURCE_CLASS = "source_class";
    public static final String JSON_KEY_CONTEXT = "context";
    public static final String JSON_KEY_EXCEPTION = "exception";
    public static final String JSON_KEY_CAUSE = "cause";
    public static final String JSON_KEY_SUPPRESSED = "suppressed";
    public static final String JSON_KEY_EXCEPTION_CLASS = "exception_class";
    public static final String JSON_KEY_EXCEPTION_MESSAGE = "exception_message";
    public static final String JSON_KEY_EXCEPTION_STACKTRACE = "stacktrace";
    public static final String JSON_KEY_THREAD_ID = "thread_id";
    public static final String JSON_KEY_THREAD_NAME = "thread_name";
    static final int LOGSTASH_JSON_VERSION = 1;
    static final String ISO8601_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZZ";
    static final String PROPERTY_PREFIX = JsonEventFormatter.class.getName() + ".";
    static final String TAG_PROPERTY = "tags";
    static final String PRETTY_PROPERTY = "pretty";
    static final String SOURCE_PROPERTY = "source";
    static final String SOURCEHOST_PROPERTY = "source_host";
    static final String TAG_SEPARATOR_REGEX = "[, ]+";
    private static final SimpleDateFormat dateFormatterMaster = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
    private final JsonGeneratorFactory jsonFactory;
    private final String hostName;
    private final String sourceName;
    private final List<String> tags;
    private volatile SortedMap<Long, String> threadNames;
    private final Semaphore threadNamesLock;

    public JsonEventFormatter() {
        this(JsonEventFormatter.getLoggerPropertyOrDefault("source_host", JsonEventFormatter.defaultHostName()), JsonEventFormatter.getLoggerPropertyOrDefault("source", "java"), JsonEventFormatter.defaultTags(), JsonEventFormatter.defaultJsonFactory());
    }

    private static String defaultHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            return "unknown-host";
        }
    }

    private static List<String> defaultTags() {
        String configuredTagsString = JsonEventFormatter.getLoggerPropertyOrDefault(TAG_PROPERTY, "");
        if (!"".equals(configuredTagsString)) {
            String[] configuredTags = configuredTagsString.split(TAG_SEPARATOR_REGEX);
            return Arrays.asList(configuredTags);
        }
        return new ArrayList<String>();
    }

    private static JsonGeneratorFactory defaultJsonFactory() {
        String prettyProperty = JsonEventFormatter.getLoggerPropertyOrDefault(PRETTY_PROPERTY, "false");
        HashMap<String, String> jsonConfig = new HashMap<String, String>(1);
        if ("true".equalsIgnoreCase(prettyProperty) || "yes".equalsIgnoreCase(prettyProperty)) {
            jsonConfig.put("javax.json.stream.JsonGenerator.prettyPrinting", prettyProperty);
        }
        return Json.createGeneratorFactory(jsonConfig);
    }

    public JsonEventFormatter(String hostName, String source, List<String> tags, JsonGeneratorFactory jsonFactory) {
        assert (hostName != null);
        assert (source != null);
        assert (tags != null);
        assert (jsonFactory != null);
        this.hostName = hostName;
        this.sourceName = source;
        this.tags = Collections.unmodifiableList(new ArrayList<String>(tags));
        this.jsonFactory = jsonFactory;
        this.threadNames = Collections.unmodifiableSortedMap(new TreeMap());
        this.threadNamesLock = new Semaphore(1);
    }

    @Override
    public String format(LogRecord record) {
        Map context;
        Throwable thrown;
        SimpleDateFormat dateFormatter = (SimpleDateFormat)dateFormatterMaster.clone();
        String timeStampString = dateFormatter.format(new Date(record.getMillis()));
        String formattedMessage = this.formatMessage(record);
        StringWriter writer = new StringWriter();
        JsonGenerator json = this.jsonFactory.createGenerator((Writer)writer);
        json.writeStartObject().write(JSON_KEY_VERSION, 1).write(JSON_KEY_TIMESTAMP, timeStampString).write("source_host", this.hostName).write("source", this.sourceName).write(JSON_KEY_LEVEL, record.getLevel().getName()).write(JSON_KEY_MESSAGE, formattedMessage).write(JSON_KEY_THREAD_ID, record.getThreadID());
        String threadName = this.getThreadName(record.getThreadID());
        if (null != threadName) {
            json.write(JSON_KEY_THREAD_NAME, threadName);
        }
        if (null != record.getLoggerName()) {
            json.write(JSON_KEY_LOGGER_NAME, record.getLoggerName());
        }
        if (null != record.getSourceClassName()) {
            json.write(JSON_KEY_SOURCE_CLASS, record.getSourceClassName());
        }
        if (null != record.getSourceMethodName()) {
            json.write(JSON_KEY_SOURCE_METHOD, record.getSourceMethodName());
        }
        if (!this.tags.isEmpty()) {
            json.writeStartArray(TAG_PROPERTY);
            for (String tag : this.tags) {
                json.write(tag);
            }
            json.writeEnd();
        }
        if ((thrown = record.getThrown()) != null) {
            json.writeStartObject(JSON_KEY_EXCEPTION);
            boolean withDescription = true;
            JsonEventFormatter.writeThrowableToJson(json, thrown, withDescription);
            json.writeEnd();
        }
        Map map = context = thrown != null ? LoggingContext.getLastEnteredContext() : LoggingContext.getContext();
        if (context != null) {
            JsonEventFormatter.writeContextToJson(json, context);
        }
        json.writeEnd();
        json.flush();
        writer.append('\n');
        return writer.toString();
    }

    private static void writeContextToJson(JsonGenerator json, Map<String, String> context) {
        if (!context.isEmpty()) {
            json.writeStartObject(JSON_KEY_CONTEXT);
            for (Map.Entry<String, String> entry : context.entrySet()) {
                json.write(entry.getKey(), entry.getValue());
            }
            json.writeEnd();
        }
    }

    private static void writeThrowableToJson(JsonGenerator json, Throwable thrown, boolean withDescription) {
        Throwable cause;
        String exceptionClass = thrown.getClass().getCanonicalName();
        String exceptionMessage = thrown.getMessage();
        if (exceptionClass != null) {
            json.write(JSON_KEY_EXCEPTION_CLASS, exceptionClass);
        }
        if (exceptionMessage != null) {
            json.write(JSON_KEY_EXCEPTION_MESSAGE, exceptionMessage);
        }
        if (withDescription) {
            StringWriter stackWriter = new StringWriter();
            thrown.printStackTrace(new PrintWriter(stackWriter));
            String stack = stackWriter.toString();
            if (!stack.isEmpty()) {
                json.write(JSON_KEY_EXCEPTION_STACKTRACE, stack);
            }
        }
        boolean noDescription = false;
        Throwable[] suppressed = thrown.getSuppressed();
        if (null != suppressed && suppressed.length > 0) {
            json.writeStartArray(JSON_KEY_SUPPRESSED);
            for (Throwable oneSuppressed : suppressed) {
                json.writeStartObject();
                JsonEventFormatter.writeThrowableToJson(json, oneSuppressed, false);
                json.writeEnd();
            }
            json.writeEnd();
        }
        if (null != (cause = thrown.getCause())) {
            json.writeStartObject(JSON_KEY_CAUSE);
            JsonEventFormatter.writeThrowableToJson(json, cause, false);
            json.writeEnd();
        }
    }

    private static String getLoggerPropertyOrDefault(String propertyName, String defaultValue) {
        String foundProperty = LogManager.getLogManager().getProperty(PROPERTY_PREFIX + propertyName);
        return foundProperty != null ? foundProperty : defaultValue;
    }

    private String getThreadName(long tid) {
        if (!this.threadNames.containsKey(tid) && this.threadNamesLock.tryAcquire()) {
            try {
                this.updateThreadNames();
            }
            finally {
                this.threadNamesLock.release();
            }
        }
        return (String)this.threadNames.get(tid);
    }

    private void updateThreadNames() {
        ThreadGroup parent;
        ThreadGroup root = Thread.currentThread().getThreadGroup();
        while (null != (parent = root.getParent())) {
            root = parent;
        }
        int active = root.activeCount();
        Thread[] threads = new Thread[active + 100];
        int enumerated = root.enumerate(threads);
        TreeMap<Long, String> names = new TreeMap<Long, String>();
        for (int i = 0; i < enumerated; ++i) {
            Thread thread = threads[i];
            names.put(thread.getId(), thread.getName());
        }
        this.threadNames = Collections.unmodifiableSortedMap(names);
    }

    String getHostName() {
        return this.hostName;
    }

    String getSourceName() {
        return this.sourceName;
    }

    List<String> getTags() {
        return new ArrayList<String>(this.tags);
    }

    static {
        dateFormatterMaster.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

