/*
 * Decompiled with CFR 0.152.
 */
package com.cognitect.transit.impl;

import com.cognitect.transit.Keyword;
import com.cognitect.transit.Ratio;
import com.cognitect.transit.Symbol;
import com.cognitect.transit.TaggedValue;
import com.cognitect.transit.URI;
import com.cognitect.transit.WriteHandler;
import com.cognitect.transit.impl.LinkImpl;
import com.cognitect.transit.impl.Quote;
import com.cognitect.transit.impl.TagProvider;
import com.cognitect.transit.impl.TagProviderAware;
import com.cognitect.transit.impl.WriteHandlers;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class WriteHandlerMap
implements TagProvider,
Map<Class, WriteHandler<?, ?>> {
    public static final Map<Class, WriteHandler<?, ?>> defaults = WriteHandlerMap.defaultHandlers();
    private final Map<Class, WriteHandler<?, ?>> handlers = new HashMap();
    private WriteHandlerMap verboseHandlerMap;

    private static Map<Class, WriteHandler<?, ?>> defaultHandlers() {
        HashMap handlers = new HashMap();
        WriteHandlers.IntegerWriteHandler integerHandler = new WriteHandlers.IntegerWriteHandler();
        WriteHandlers.ToStringWriteHandler uriHandler = new WriteHandlers.ToStringWriteHandler("r");
        WriteHandlers.ArrayWriteHandler arrayHandler = new WriteHandlers.ArrayWriteHandler();
        handlers.put(Boolean.class, new WriteHandlers.BooleanWriteHandler());
        handlers.put(null, new WriteHandlers.NullWriteHandler());
        handlers.put(String.class, new WriteHandlers.ToStringWriteHandler("s"));
        handlers.put(Integer.class, integerHandler);
        handlers.put(Long.class, integerHandler);
        handlers.put(Short.class, integerHandler);
        handlers.put(Byte.class, integerHandler);
        handlers.put(BigInteger.class, new WriteHandlers.ToStringWriteHandler("n"));
        handlers.put(Float.class, new WriteHandlers.FloatWriteHandler());
        handlers.put(Double.class, new WriteHandlers.DoubleWriteHandler());
        handlers.put(BigDecimal.class, new WriteHandlers.ToStringWriteHandler("f"));
        handlers.put(Character.class, new WriteHandlers.ToStringWriteHandler("c"));
        handlers.put(Keyword.class, new WriteHandlers.KeywordWriteHandler());
        handlers.put(Symbol.class, new WriteHandlers.ToStringWriteHandler("$"));
        handlers.put(byte[].class, new WriteHandlers.BinaryWriteHandler());
        handlers.put(UUID.class, new WriteHandlers.UUIDWriteHandler());
        handlers.put(java.net.URI.class, uriHandler);
        handlers.put(URI.class, uriHandler);
        handlers.put(List.class, new WriteHandlers.ListWriteHandler());
        handlers.put(Object[].class, arrayHandler);
        handlers.put(int[].class, arrayHandler);
        handlers.put(long[].class, arrayHandler);
        handlers.put(float[].class, arrayHandler);
        handlers.put(double[].class, arrayHandler);
        handlers.put(short[].class, arrayHandler);
        handlers.put(boolean[].class, arrayHandler);
        handlers.put(char[].class, arrayHandler);
        handlers.put(Set.class, new WriteHandlers.SetWriteHandler());
        handlers.put(Date.class, new WriteHandlers.TimeWriteHandler());
        handlers.put(Ratio.class, new WriteHandlers.RatioWriteHandler());
        handlers.put(LinkImpl.class, new WriteHandlers.LinkWriteHandler());
        handlers.put(Quote.class, new WriteHandlers.QuoteAbstractEmitter());
        handlers.put(TaggedValue.class, new WriteHandlers.TaggedValueWriteHandler());
        return Collections.unmodifiableMap(handlers);
    }

    public WriteHandlerMap() {
        this(null);
    }

    public WriteHandlerMap(Map<Class, WriteHandler<?, ?>> customHandlers) {
        if (customHandlers instanceof WriteHandlerMap) {
            this.handlers.putAll(customHandlers);
        } else {
            this.handlers.putAll(defaults);
            if (customHandlers != null) {
                this.handlers.putAll(customHandlers);
            }
        }
        this.handlers.put(Map.class, new WriteHandlers.MapWriteHandler());
        this.setTagProvider(this.handlers);
    }

    public WriteHandlerMap verboseWriteHandlerMap() {
        if (this.verboseHandlerMap == null) {
            HashMap verboseHandlers = new HashMap(this.handlers.size());
            for (Map.Entry<Class, WriteHandler<?, ?>> entry : this.handlers.entrySet()) {
                WriteHandler verboseHandler = entry.getValue().getVerboseHandler();
                verboseHandlers.put(entry.getKey(), verboseHandler == null ? entry.getValue() : verboseHandler);
            }
            this.verboseHandlerMap = new WriteHandlerMap(verboseHandlers);
        }
        return this.verboseHandlerMap;
    }

    private void setTagProvider(Map<Class, WriteHandler<?, ?>> handlers) {
        for (WriteHandler<?, ?> h : handlers.values()) {
            if (!(h instanceof TagProviderAware)) continue;
            ((TagProviderAware)((Object)h)).setTagProvider(this);
        }
    }

    private Map<Class, WriteHandler<?, ?>> getUnderlyingMap() {
        return this.handlers;
    }

    @Override
    public int size() {
        return this.handlers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.handlers.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.handlers.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.handlers.containsValue(value);
    }

    @Override
    public WriteHandler<?, ?> get(Object key) {
        return this.handlers.get(key);
    }

    @Override
    public WriteHandler<?, ?> put(Class key, WriteHandler<?, ?> value) {
        throw new UnsupportedOperationException("WriteHandlerMap is read-only");
    }

    @Override
    public WriteHandler<?, ?> remove(Object key) {
        throw new UnsupportedOperationException("WriteHandlerMap is read-only");
    }

    @Override
    public void putAll(Map<? extends Class, ? extends WriteHandler<?, ?>> m) {
        throw new UnsupportedOperationException("WriteHandlerMap is read-only");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("WriteHandlerMap is read-only");
    }

    @Override
    public Set<Class> keySet() {
        return this.handlers.keySet();
    }

    @Override
    public Collection<WriteHandler<?, ?>> values() {
        return this.handlers.values();
    }

    @Override
    public Set<Map.Entry<Class, WriteHandler<?, ?>>> entrySet() {
        return this.handlers.entrySet();
    }

    @Override
    public int hashCode() {
        return this.handlers.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof WriteHandlerMap && this.getUnderlyingMap().equals(((WriteHandlerMap)other).getUnderlyingMap());
    }

    public WriteHandler<Object, Object> getHandler(Object o) {
        Class<?> c = o != null ? o.getClass() : null;
        WriteHandler<Object, Object> h = null;
        if (h == null) {
            h = this.handlers.get(c);
        }
        if (h == null) {
            h = this.checkBaseClasses(c);
        }
        if (h == null) {
            h = this.checkBaseInterfaces(c);
        }
        return h;
    }

    private WriteHandler<?, ?> checkBaseClasses(Class c) {
        for (Class base = c.getSuperclass(); base != Object.class; base = base.getSuperclass()) {
            WriteHandler<?, ?> h = this.handlers.get(base);
            if (h == null) continue;
            this.handlers.put(c, h);
            return h;
        }
        return null;
    }

    private WriteHandler<?, ?> checkBaseInterfaces(Class c) {
        HashMap possibles = new HashMap();
        for (Class base = c; base != Object.class; base = base.getSuperclass()) {
            for (Class<?> itf : base.getInterfaces()) {
                WriteHandler<?, ?> h = this.handlers.get(itf);
                if (h == null) continue;
                possibles.put(itf, h);
            }
        }
        switch (possibles.size()) {
            case 0: {
                return null;
            }
            case 1: {
                WriteHandler h = (WriteHandler)possibles.values().iterator().next();
                this.handlers.put(c, h);
                return h;
            }
        }
        throw new RuntimeException("More than one match for " + c);
    }

    @Override
    public String getTag(Object o) {
        WriteHandler<Object, Object> h = this.getHandler(o);
        if (h == null) {
            return null;
        }
        return h.tag(o);
    }
}

