/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.SqlQueries;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicBoolean;

class SqlTableInitializer {
    private final Connection connection;
    private final SqlQueries sqlQueries;
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    SqlTableInitializer(SqlQueries sqlQueries, Connection connection) {
        this.connection = connection;
        this.sqlQueries = sqlQueries;
    }

    PreparedStatement getInitializedStatement(String sql) {
        if (this.initialized.compareAndSet(false, true)) {
            this.initialize();
        }
        try {
            return this.connection.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Could not create SQL statement", e);
        }
    }

    void initialize() {
        try (Statement statement = this.connection.createStatement();){
            statement.executeUpdate(this.sqlQueries.createLocksTable());
            this.initialized.set(true);
        }
        catch (SQLException e) {
            try (PreparedStatement statement2 = this.connection.prepareStatement(this.sqlQueries.checkTableExits());){
                statement2.executeQuery();
                this.initialized.set(true);
            }
            catch (SQLException checkException) {
                throw new IllegalStateException("Could not initialize locks table", e);
            }
        }
    }
}

