/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.LockDuration;
import com.coditory.sherlock.LockId;
import com.coditory.sherlock.OwnerId;
import com.coditory.sherlock.util.Preconditions;
import java.util.Objects;

final class LockRequest {
    private final LockId lockId;
    private final OwnerId ownerId;
    private final LockDuration duration;

    public LockRequest(LockId lockId, OwnerId ownerId, LockDuration duration) {
        this.lockId = Preconditions.expectNonNull(lockId);
        this.ownerId = Preconditions.expectNonNull(ownerId);
        this.duration = duration;
    }

    public LockRequest(LockId lockId, OwnerId ownerId) {
        this.lockId = Preconditions.expectNonNull(lockId);
        this.ownerId = Preconditions.expectNonNull(ownerId);
        this.duration = null;
    }

    public LockId getLockId() {
        return this.lockId;
    }

    public OwnerId getOwnerId() {
        return this.ownerId;
    }

    public LockDuration getDuration() {
        return this.duration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LockRequest request = (LockRequest)o;
        return Objects.equals(this.lockId, request.lockId) && Objects.equals(this.ownerId, request.ownerId) && Objects.equals(this.duration, request.duration);
    }

    public int hashCode() {
        return Objects.hash(this.lockId, this.ownerId, this.duration);
    }

    public String toString() {
        return "LockRequest{lockId=" + this.lockId + ", ownerId=" + this.ownerId + ", duration=" + this.duration + "}";
    }
}

