/*
 * Decompiled with CFR 0.152.
 */
package com.codingrodent.jackson.crypto;

import com.codingrodent.jackson.crypto.Encrypt;
import com.codingrodent.jackson.crypto.EncryptedJsonDeserializer;
import com.codingrodent.jackson.crypto.EncryptionService;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import java.util.Iterator;

public class EncryptedDeserializerModifier
extends BeanDeserializerModifier {
    private final EncryptionService encryptionService;

    public EncryptedDeserializerModifier(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }

    public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription beanDescription, BeanDeserializerBuilder builder) {
        Iterator it = builder.getProperties();
        while (it.hasNext()) {
            SettableBeanProperty property = (SettableBeanProperty)it.next();
            if (null == property.getAnnotation(Encrypt.class)) continue;
            JsonDeserializer current = property.getValueDeserializer();
            builder.addOrReplaceProperty(property.withValueDeserializer((JsonDeserializer)new EncryptedJsonDeserializer(this.encryptionService, (JsonDeserializer<Object>)current)), true);
        }
        return builder;
    }
}

