/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.txmsg;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum LCNCmdType {
    notifyUnit("notify-unit", "notifyUnit"),
    createGroup("create-group", "createGroup"),
    joinGroup("join-group", "joinGroup"),
    notifyGroup("notify-group", "notifyGroup"),
    acquireDTXLock("acquire-dtx-lock", "qdtxl"),
    releaseDTXLock("release-dtx-lock", "rdtxl"),
    askTransactionState("ask-transaction-state", "askTransactionState"),
    writeCompensation("write-exception", "writeException"),
    notifyConnect("notify-connect", "ntm"),
    initClient("init-client", "init"),
    getAspectLog("get-aspect-log", "gal"),
    deleteAspectLog("delete-aspect-log", "dal"),
    queryTMCluster("query-tm-cluster", "qtmc"),
    cleanInvalidTM("clean-invalid-tm", "citm");

    private static final Logger log;
    private String code;
    private String name;

    private LCNCmdType(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static LCNCmdType parserCmd(String cmd) {
        log.debug("parsed txmsg cmd: {}", (Object)cmd);
        switch (cmd) {
            case "createGroup": {
                return createGroup;
            }
            case "notifyGroup": {
                return notifyGroup;
            }
            case "notifyUnit": {
                return notifyUnit;
            }
            case "joinGroup": {
                return joinGroup;
            }
            case "qdtxl": {
                return acquireDTXLock;
            }
            case "rdtxl": {
                return releaseDTXLock;
            }
            case "askTransactionState": {
                return askTransactionState;
            }
            case "writeException": {
                return writeCompensation;
            }
            case "ntm": {
                return notifyConnect;
            }
            case "gal": {
                return getAspectLog;
            }
            case "dal": {
                return deleteAspectLog;
            }
            case "init": {
                return initClient;
            }
            case "qtmc": {
                return queryTMCluster;
            }
            case "citm": {
                return cleanInvalidTM;
            }
        }
        throw new IllegalStateException("unsupported cmd.");
    }

    static {
        log = LoggerFactory.getLogger(LCNCmdType.class);
    }
}

