/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.txmsg.netty.impl;

import com.codingapi.txlcn.txmsg.RpcClient;
import com.codingapi.txlcn.txmsg.dto.AppInfo;
import com.codingapi.txlcn.txmsg.dto.MessageDto;
import com.codingapi.txlcn.txmsg.dto.RpcCmd;
import com.codingapi.txlcn.txmsg.dto.RpcResponseState;
import com.codingapi.txlcn.txmsg.exception.RpcException;
import com.codingapi.txlcn.txmsg.netty.bean.NettyRpcCmd;
import com.codingapi.txlcn.txmsg.netty.bean.SocketManager;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NettyRpcClient
extends RpcClient {
    private static final Logger log = LoggerFactory.getLogger(NettyRpcClient.class);

    public RpcResponseState send(RpcCmd rpcCmd) throws RpcException {
        return SocketManager.getInstance().send(rpcCmd.getRemoteKey(), rpcCmd);
    }

    public RpcResponseState send(String remoteKey, MessageDto msg) throws RpcException {
        NettyRpcCmd rpcCmd = new NettyRpcCmd();
        rpcCmd.setMsg(msg);
        rpcCmd.setRemoteKey(remoteKey);
        return this.send(rpcCmd);
    }

    public MessageDto request(RpcCmd rpcCmd) throws RpcException {
        return this.request0(rpcCmd, -1L);
    }

    private MessageDto request0(RpcCmd rpcCmd, long timeout) throws RpcException {
        if (rpcCmd.getKey() == null) {
            throw new RpcException("key must be not null.");
        }
        return SocketManager.getInstance().request(rpcCmd.getRemoteKey(), rpcCmd, timeout);
    }

    public MessageDto request(String remoteKey, MessageDto msg) throws RpcException {
        return this.request(remoteKey, msg, -1L);
    }

    public MessageDto request(String remoteKey, MessageDto msg, long timeout) throws RpcException {
        long startTime = System.currentTimeMillis();
        NettyRpcCmd rpcCmd = new NettyRpcCmd();
        rpcCmd.setMsg(msg);
        String key = rpcCmd.randomKey();
        rpcCmd.setKey(key);
        rpcCmd.setRemoteKey(remoteKey);
        MessageDto result = this.request0(rpcCmd, timeout);
        log.debug("cmd request used time: {} ms", (Object)(System.currentTimeMillis() - startTime));
        return result;
    }

    public List<String> loadAllRemoteKey() {
        return SocketManager.getInstance().loadAllRemoteKey();
    }

    public List<String> remoteKeys(String moduleName) {
        return SocketManager.getInstance().removeKeys(moduleName);
    }

    public void bindAppName(String remoteKey, String appName, String labelName) throws RpcException {
        SocketManager.getInstance().bindModuleName(remoteKey, appName, labelName);
    }

    public String getAppName(String remoteKey) {
        return SocketManager.getInstance().getModuleName(remoteKey);
    }

    public List<AppInfo> apps() {
        return SocketManager.getInstance().appInfos();
    }
}

