/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.txmsg.netty.bean;

import com.codingapi.txlcn.txmsg.dto.MessageDto;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class RpcContent {
    private long milliseconds;
    private volatile MessageDto res;
    private Condition condition;
    private Lock lock;
    private volatile boolean used = false;

    public void init() {
        this.used = true;
    }

    public void clear() {
        this.used = false;
        this.res = null;
    }

    public boolean isUsed() {
        return this.used;
    }

    public RpcContent(long milliseconds) {
        this.milliseconds = milliseconds;
        this.lock = new ReentrantLock(true);
        this.condition = this.lock.newCondition();
    }

    public void await() {
        this.await(this.milliseconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await(long timeout) {
        try {
            this.lock.lock();
            try {
                this.condition.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void signal() {
        try {
            this.lock.lock();
            this.condition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDto getRes() {
        RpcContent rpcContent = this;
        synchronized (rpcContent) {
            return this.res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRes(MessageDto res) {
        RpcContent rpcContent = this;
        synchronized (rpcContent) {
            this.res = res;
        }
    }

    public void setMilliseconds(int milliseconds) {
        this.milliseconds = milliseconds;
    }
}

