/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tracing.http;

import com.codingapi.txlcn.tracing.Tracings;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@ConditionalOnClass(value={RestTemplate.class})
@Component
@Order
public class RestTemplateTracingTransmitter
implements ClientHttpRequestInterceptor {
    @Autowired
    public RestTemplateTracingTransmitter(@Autowired(required=false) List<RestTemplate> restTemplates) {
        if (Objects.nonNull(restTemplates)) {
            restTemplates.forEach(restTemplate -> {
                List interceptors = restTemplate.getInterceptors();
                interceptors.add(interceptors.size(), this);
            });
        }
    }

    @NonNull
    public ClientHttpResponse intercept(@NonNull HttpRequest httpRequest, @NonNull byte[] bytes, @NonNull ClientHttpRequestExecution clientHttpRequestExecution) throws IOException {
        Tracings.transmit((arg_0, arg_1) -> ((HttpHeaders)httpRequest.getHeaders()).add(arg_0, arg_1));
        return clientHttpRequestExecution.execute(httpRequest, bytes);
    }
}

