/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.txmsg;

import com.codingapi.txlcn.logger.TxLogger;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.StatementInfo;
import com.codingapi.txlcn.tc.txmsg.MessageCreator;
import com.codingapi.txlcn.tc.txmsg.ReliableMessenger;
import com.codingapi.txlcn.txmsg.exception.RpcException;
import com.codingapi.txlcn.txmsg.params.TxExceptionParams;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TMReporter {
    private final ReliableMessenger reliableMessenger;
    private static final TxLogger txLogger = TxLogger.newLogger(TMReporter.class);
    private static final String REPORT_ERROR_MESSAGE = "report transaction transactionState error";

    @Autowired
    public TMReporter(ReliableMessenger reliableMessenger) {
        this.reliableMessenger = reliableMessenger;
    }

    public void reportTransactionState(String groupId, String unitId, Short registrar, int state) {
        TxExceptionParams txExceptionParams = new TxExceptionParams();
        txExceptionParams.setGroupId(groupId);
        txExceptionParams.setRegistrar(registrar);
        txExceptionParams.setTransactionState(Integer.valueOf(state));
        txExceptionParams.setUnitId(unitId);
        this.report(txExceptionParams);
    }

    public void reportTccCleanException(String groupId, String unitId, int state) {
        TxExceptionParams txExceptionParams = new TxExceptionParams();
        txExceptionParams.setGroupId(groupId);
        txExceptionParams.setRegistrar(Short.valueOf((short)3));
        txExceptionParams.setTransactionState(Integer.valueOf(state));
        txExceptionParams.setUnitId(unitId);
        this.report(txExceptionParams);
    }

    private void report(TxExceptionParams exceptionParams) {
        try {
            this.reliableMessenger.request(MessageCreator.writeTxException(exceptionParams));
        }
        catch (RpcException e) {
            txLogger.trace(exceptionParams.getGroupId(), exceptionParams.getUnitId(), "TM report", REPORT_ERROR_MESSAGE, new Object[0]);
        }
    }

    public void reportTxcUndoException(String groupId, String unitId, List<StatementInfo> statementInfoList) {
        TxExceptionParams exceptionParams = new TxExceptionParams();
        exceptionParams.setGroupId(groupId);
        exceptionParams.setUnitId(unitId);
        exceptionParams.setRegistrar(TxExceptionParams.TXC_UNDO_ERROR);
        exceptionParams.setTransactionState(Integer.valueOf(0));
        exceptionParams.setRemark(statementInfoList.toString());
        this.report(exceptionParams);
    }
}

