/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.txmsg;

import com.codingapi.txlcn.tc.config.TxClientConfig;
import com.codingapi.txlcn.tc.support.listener.RpcEnvStatusListener;
import com.codingapi.txlcn.tc.txmsg.ReliableMessenger;
import com.codingapi.txlcn.tc.txmsg.TMSearcher;
import com.codingapi.txlcn.txmsg.exception.RpcException;
import com.google.common.collect.Sets;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AutoTMClusterEngine
implements RpcEnvStatusListener {
    private static final Logger log = LoggerFactory.getLogger(AutoTMClusterEngine.class);
    private AtomicInteger tryConnectCount = new AtomicInteger(0);
    private final TxClientConfig txClientConfig;
    private final ReliableMessenger reliableMessenger;

    @Autowired
    public AutoTMClusterEngine(TxClientConfig txClientConfig, ReliableMessenger reliableMessenger) {
        this.txClientConfig = txClientConfig;
        this.reliableMessenger = reliableMessenger;
    }

    @Override
    public void onConnected(String remoteKey) {
    }

    @Override
    public void onInitialized(String remoteKey) {
        if (this.prepareToResearchTMCluster()) {
            TMSearcher.echoTmClusterSize();
        }
    }

    @Override
    public void onConnectFail(String remoteKey) {
        try {
            this.reliableMessenger.reportInvalidTM(Sets.newHashSet((Object[])new String[]{remoteKey}));
        }
        catch (RpcException e) {
            log.error("{} on reportInvalidTM.", (Object)e.getMessage());
        }
        if (this.prepareToResearchTMCluster()) {
            TMSearcher.echoTmClusterSize();
        }
    }

    private boolean prepareToResearchTMCluster() {
        int size;
        int count = this.tryConnectCount.incrementAndGet();
        if (count == (size = this.txClientConfig.getManagerAddress().size())) {
            TMSearcher.search();
            return false;
        }
        if (count > size) {
            return !TMSearcher.searchedOne();
        }
        return true;
    }
}

