/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.corelog;

import java.io.File;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@ConfigurationProperties(value="tx-lcn.aspect.log")
public class H2DbProperties {
    private String filePath;

    public H2DbProperties(@Autowired(required=false) ConfigurableEnvironment environment, @Autowired(required=false) ServerProperties serverProperties) {
        String applicationName = "application";
        Integer port = 0;
        if (Objects.nonNull(environment)) {
            applicationName = environment.getProperty("spring.application.name");
        }
        if (Objects.nonNull(serverProperties)) {
            port = serverProperties.getPort();
        }
        this.filePath = System.getProperty("user.dir") + File.separator + ".txlcn" + File.separator + (StringUtils.hasText((String)applicationName) ? applicationName : "application") + "-" + port;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof H2DbProperties)) {
            return false;
        }
        H2DbProperties other = (H2DbProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$filePath = this.getFilePath();
        String other$filePath = other.getFilePath();
        return !(this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof H2DbProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
        return result;
    }

    public String toString() {
        return "H2DbProperties(filePath=" + this.getFilePath() + ")";
    }
}

