/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.core.context;

import com.codingapi.txlcn.tc.core.context.AttachmentCache;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Component;

@Component
public class MapBasedAttachmentCache
implements AttachmentCache {
    private Map<String, Map<String, Object>> cache = new ConcurrentHashMap<String, Map<String, Object>>(64);
    private Map<String, Object> singlePropCache = new ConcurrentHashMap<String, Object>(64);

    @Override
    public void attach(String mainKey, String key, Object attachment) {
        Objects.requireNonNull(mainKey);
        Objects.requireNonNull(key);
        Objects.requireNonNull(attachment);
        if (this.cache.containsKey(mainKey)) {
            Map<String, Object> map = this.cache.get(mainKey);
            map.put(key, attachment);
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, attachment);
        this.cache.put(mainKey, map);
    }

    @Override
    public void attach(String key, Object attachment) {
        this.singlePropCache.put(key, attachment);
    }

    @Override
    public <T> T attachment(String mainKey, String key) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(mainKey);
        if (this.cache.containsKey(mainKey) && this.cache.get(mainKey).containsKey(key)) {
            return (T)this.cache.get(mainKey).get(key);
        }
        return null;
    }

    @Override
    public <T> T attachment(String key) {
        return (T)this.singlePropCache.get(key);
    }

    @Override
    public void remove(String mainKey, String key) {
        if (this.cache.containsKey(mainKey)) {
            this.cache.get(mainKey).remove(key);
        }
    }

    @Override
    public void removeAll(String mainKey) {
        this.cache.remove(mainKey);
    }

    @Override
    public boolean containsKey(String mainKey, String key) {
        return this.cache.containsKey(mainKey) && this.cache.get(mainKey).containsKey(key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.singlePropCache.containsKey(key);
    }

    @Override
    public void remove(String key) {
        this.singlePropCache.remove(key);
    }
}

