/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.core;

import com.codingapi.txlcn.common.exception.TransactionException;
import com.codingapi.txlcn.logger.TxLogger;
import com.codingapi.txlcn.tc.core.DTXLocalControl;
import com.codingapi.txlcn.tc.core.DTXPropagationState;
import com.codingapi.txlcn.tc.core.TxTransactionInfo;
import com.codingapi.txlcn.tc.core.context.TCGlobalContext;
import com.codingapi.txlcn.tc.core.propagation.DTXPropagationResolver;
import com.codingapi.txlcn.tc.support.TxLcnBeanHelper;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DTXServiceExecutor {
    private static final Logger log = LoggerFactory.getLogger(DTXServiceExecutor.class);
    private static final TxLogger txLogger = TxLogger.newLogger(DTXServiceExecutor.class);
    private final TCGlobalContext globalContext;
    private final TxLcnBeanHelper txLcnBeanHelper;
    private final DTXPropagationResolver propagationResolver;

    @Autowired
    public DTXServiceExecutor(TxLcnBeanHelper txLcnBeanHelper, TCGlobalContext globalContext, DTXPropagationResolver propagationResolver) {
        this.txLcnBeanHelper = txLcnBeanHelper;
        this.globalContext = globalContext;
        this.propagationResolver = propagationResolver;
    }

    public Object transactionRunning(TxTransactionInfo info) throws Throwable {
        String transactionType = info.getTransactionType();
        DTXPropagationState propagationState = this.propagationResolver.resolvePropagationState(info);
        if (propagationState.isIgnored()) {
            return info.getBusinessCallback().call();
        }
        DTXLocalControl dtxLocalControl = this.txLcnBeanHelper.loadDTXLocalControl(transactionType, propagationState);
        try {
            Set<String> transactionTypeSet = this.globalContext.txContext(info.getGroupId()).getTransactionTypes();
            transactionTypeSet.add(transactionType);
            dtxLocalControl.preBusinessCode(info);
            txLogger.txTrace(info.getGroupId(), info.getUnitId(), "pre business code, unit type: {}", new Object[]{transactionType});
            Object result = dtxLocalControl.doBusinessCode(info);
            txLogger.txTrace(info.getGroupId(), info.getUnitId(), "business success", new Object[0]);
            dtxLocalControl.onBusinessCodeSuccess(info, result);
            Object object = result;
            return object;
        }
        catch (TransactionException e) {
            txLogger.error(info.getGroupId(), info.getUnitId(), new Object[]{"before business code error"});
            throw e;
        }
        catch (Throwable e) {
            txLogger.error(info.getGroupId(), info.getUnitId(), "Transaction", "business code error", new Object[0]);
            dtxLocalControl.onBusinessCodeError(info, e);
            throw e;
        }
        finally {
            dtxLocalControl.postBusinessCode(info);
        }
    }
}

