/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.logger;

import com.codingapi.txlcn.common.util.SpringUtils;
import com.codingapi.txlcn.common.util.Transactions;
import com.codingapi.txlcn.logger.TxLogger;
import com.codingapi.txlcn.logger.db.LogDbProperties;
import com.codingapi.txlcn.logger.db.TxLog;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class AbstractTxLogger
implements TxLogger {
    private final ExecutorService loggerSaveService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    private final Logger LOG;
    private LogDbProperties logDbProperties;

    public AbstractTxLogger(Class<?> className) {
        this.LOG = LoggerFactory.getLogger(className);
    }

    @Override
    public void trace(String groupId, String unitId, String tag, String content, Object ... args) {
        if (Objects.isNull((Object)this.logDbProperties)) {
            this.logDbProperties = (LogDbProperties)((Object)SpringUtils.getBean(LogDbProperties.class));
        }
        if (this.logDbProperties.isEnabled() && !this.logDbProperties.isOnlyError()) {
            this.saveTxLog(groupId, unitId, tag, content, args);
        }
        this.LOG.debug(content + " @group(" + groupId + ")", args);
    }

    @Override
    public void error(String groupId, String unitId, String tag, String content, Object ... args) {
        if (Objects.isNull((Object)this.logDbProperties)) {
            this.logDbProperties = (LogDbProperties)((Object)SpringUtils.getBean(LogDbProperties.class));
        }
        if (this.logDbProperties.isEnabled() && this.logDbProperties.isOnlyError()) {
            this.saveTxLog(groupId, unitId, tag, content, args);
        }
        this.LOG.error(content + " @group(" + groupId + ")", args);
    }

    private void saveTxLog(String groupId, String unitId, String tag, String content, Object ... args) {
        TxLog txLog = new TxLog();
        txLog.setContent(content);
        txLog.setArgs(args);
        txLog.setTag(tag);
        txLog.setGroupId(StringUtils.isEmpty((Object)groupId) ? "" : groupId);
        txLog.setUnitId(StringUtils.isEmpty((Object)unitId) ? "" : unitId);
        txLog.setAppName(Transactions.APPLICATION_ID_WHEN_RUNNING);
        txLog.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS").format(new Date()));
        this.loggerSaveService.execute(() -> this.saveLog(txLog));
    }

    public abstract void saveLog(TxLog var1);
}

