/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack;

import com.codepoetics.protonpack.comparators.Comparators;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.BiPredicate;
import java.util.function.Consumer;

class AggregatingSpliterator<I>
implements Spliterator<List<I>> {
    private final Spliterator<I> source;
    private final BiPredicate<List<I>, I> condition;
    private List<I> currentSlide = new ArrayList<I>();

    AggregatingSpliterator(Spliterator<I> source, BiPredicate<List<I>, I> predicate) {
        this.source = source;
        this.condition = predicate;
    }

    @Override
    public boolean tryAdvance(Consumer<? super List<I>> action) {
        boolean hadElements = this.source.tryAdvance((? super T curElem) -> {
            if (!this.isSameSlide(curElem)) {
                action.accept(this.currentSlide);
                this.currentSlide = new ArrayList<I>();
            }
            this.currentSlide.add(curElem);
        });
        if (!hadElements && !this.currentSlide.isEmpty()) {
            action.accept(this.currentSlide);
            this.currentSlide = new ArrayList<I>();
        }
        return hadElements;
    }

    private boolean isSameSlide(I curEl) {
        return this.currentSlide.isEmpty() || this.condition.test(this.currentSlide, curEl);
    }

    @Override
    public Spliterator<List<I>> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return this.source.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.source.characteristics() & 0xFFFFFFBF & 0xFFFFEFFF;
    }

    @Override
    public Comparator<? super List<I>> getComparator() {
        Comparator<I> comparator = this.source.getComparator();
        return comparator == null ? null : Comparators.toListComparator(comparator);
    }
}

