/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack.maps;

import com.codepoetics.protonpack.maps.DefaultMapStream;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface MapStream<K, V>
extends Stream<Map.Entry<K, V>> {
    public static <K, V> MapStream<K, V> of(Map<K, V> map) {
        return new DefaultMapStream(map.entrySet().stream());
    }

    @SafeVarargs
    public static <K, V> MapStream<K, V> ofMaps(Map<K, V> ... maps) {
        return new DefaultMapStream(Stream.of(maps).flatMap(m -> m.entrySet().stream()));
    }

    public static <K, V> MapStream<K, V> of(K key, V value) {
        return new DefaultMapStream(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(key, value)));
    }

    public static <K, V> MapStream<K, V> of(K key, V value, K key1, V value1) {
        return new DefaultMapStream(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(key, value), new AbstractMap.SimpleImmutableEntry<K, V>(key1, value1)));
    }

    public static <K, V> MapStream<K, V> of(K key, V value, K key1, V value1, K key2, V value2) {
        return new DefaultMapStream(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(key, value), new AbstractMap.SimpleImmutableEntry<K, V>(key1, value1), new AbstractMap.SimpleImmutableEntry<K, V>(key2, value2)));
    }

    public static <K, V> MapStream<K, V> of(K key, V value, K key1, V value1, K key2, V value2, K key3, V value3) {
        return new DefaultMapStream(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(key, value), new AbstractMap.SimpleImmutableEntry<K, V>(key1, value1), new AbstractMap.SimpleImmutableEntry<K, V>(key2, value2), new AbstractMap.SimpleImmutableEntry<K, V>(key3, value3)));
    }

    public static <K, V> MapStream<K, V> of(K key, V value, K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        return new DefaultMapStream(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(key, value), new AbstractMap.SimpleImmutableEntry<K, V>(key1, value1), new AbstractMap.SimpleImmutableEntry<K, V>(key2, value2), new AbstractMap.SimpleImmutableEntry<K, V>(key3, value3), new AbstractMap.SimpleImmutableEntry<K, V>(key4, value4)));
    }

    default public <K1> MapStream<K1, V> mapKeys(Function<? super K, ? extends K1> mapper) {
        return new DefaultMapStream(this.map(e -> new AbstractMap.SimpleImmutableEntry(mapper.apply((Object)e.getKey()), e.getValue())));
    }

    default public <V1> MapStream<K, V1> mapValues(Function<? super V, ? extends V1> mapper) {
        return new DefaultMapStream(this.map(e -> new AbstractMap.SimpleImmutableEntry(e.getKey(), mapper.apply((Object)e.getValue()))));
    }

    default public <K1, V1> MapStream<K1, V1> mapEntries(Function<? super K, ? extends K1> keyMapper, Function<? super V, ? extends V1> valueMapper) {
        return new DefaultMapStream(this.map(e -> new AbstractMap.SimpleImmutableEntry(keyMapper.apply((Object)e.getKey()), valueMapper.apply((Object)e.getValue()))));
    }

    default public <R> Stream<R> mapEntries(BiFunction<? super K, ? super V, ? extends R> mapper) {
        return this.map(e -> mapper.apply((Object)e.getKey(), (Object)e.getValue()));
    }

    default public MapStream<K, List<V>> mergeKeys() {
        return MapStream.of(this.collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList()))));
    }

    default public MapStream<K, V> mergeKeys(BinaryOperator<V> mergeFunction) {
        return MapStream.of(this.collect(mergeFunction));
    }

    default public Map<K, V> collect() {
        return this.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    default public Map<K, V> collect(BinaryOperator<V> mergeFunction) {
        return this.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, mergeFunction));
    }

    default public MapStream<V, K> inverseMapping() {
        return new DefaultMapStream(this.map(e -> new AbstractMap.SimpleImmutableEntry(e.getValue(), e.getKey())));
    }

    public MapStream<K, V> limit(long var1);

    public MapStream<K, V> skip(long var1);

    public MapStream<K, V> sorted();

    public MapStream<K, V> sorted(Comparator<? super Map.Entry<K, V>> var1);

    public MapStream<K, V> peek(Consumer<? super Map.Entry<K, V>> var1);

    @Override
    public MapStream<K, V> onClose(Runnable var1);

    public MapStream<K, V> filter(Predicate<? super Map.Entry<K, V>> var1);

    @Override
    public MapStream<K, V> parallel();

    @Override
    public MapStream<K, V> sequential();

    @Override
    public MapStream<K, V> unordered();

    public MapStream<K, V> distinct();
}

