/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.fluvius.test.matchers;

import com.codepoetics.fluvius.test.matchers.IndentationControl;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class AMap<K, V>
extends TypeSafeDiagnosingMatcher<Map<K, V>> {
    private final Map<K, Matcher<? super V>> expectedContents;

    public static <K, V> AMap<K, V> of(Class<K> keyClass, Class<V> valueClass) {
        return new AMap(new HashMap());
    }

    public static <K, V> AMap<K, V> containing(K key, Matcher<? super V> valueMatcher) {
        HashMap<K, Matcher<? super V>> expectedContents = new HashMap<K, Matcher<? super V>>();
        expectedContents.put(key, valueMatcher);
        return new AMap(expectedContents);
    }

    public static <K, V> AMap<K, V> containing(Map<? extends K, ? extends V> values) {
        Map<? extends K, Matcher<? extends V>> expectedContents = AMap.toExpectationMap(values);
        return new AMap<K, V>(expectedContents);
    }

    private static <K, V> Map<K, Matcher<? super V>> toExpectationMap(Map<? extends K, ? extends V> values) {
        HashMap<K, Matcher> expectedContents = new HashMap<K, Matcher>();
        for (Map.Entry<K, V> entry : values.entrySet()) {
            expectedContents.put(entry.getKey(), Matchers.equalTo(entry.getValue()));
        }
        return expectedContents;
    }

    public AMap<K, V> with(K key, V value) {
        return this.with(key, Matchers.equalTo(value));
    }

    public AMap<K, V> with(K key, Matcher<? super V> valueMatcher) {
        this.expectedContents.put(key, valueMatcher);
        return this;
    }

    public AMap<K, V> withValues(Map<? extends K, ? extends V> additionalValues) {
        return this.with(AMap.toExpectationMap(additionalValues));
    }

    public AMap<K, V> with(Map<? extends K, Matcher<? super V>> additionalMatchers) {
        this.expectedContents.putAll(additionalMatchers);
        return this;
    }

    private AMap(Map<K, Matcher<? super V>> expectedContents) {
        this.expectedContents = expectedContents;
    }

    protected boolean matchesSafely(Map<K, V> kvMap, Description description) {
        boolean matches = true;
        for (Map.Entry<K, Matcher<V>> entry : this.expectedContents.entrySet()) {
            if (entry.getValue().matches(kvMap.get(entry.getKey()))) continue;
            matches = false;
            IndentationControl.newline(description).appendText(entry.getKey().toString()).appendText(": ");
            entry.getValue().describeMismatch(kvMap.get(entry.getKey()), description);
        }
        return matches;
    }

    public void describeTo(Description description) {
        if (this.expectedContents.isEmpty()) {
            description.appendText("A map");
            return;
        }
        description.appendText("A map with:");
        IndentationControl.indent();
        for (Map.Entry<K, Matcher<V>> entry : this.expectedContents.entrySet()) {
            IndentationControl.newline(description).appendText(entry.getKey().toString()).appendText(": ").appendDescriptionOf((SelfDescribing)entry.getValue());
        }
        IndentationControl.outdent();
    }
}

