/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.fluvius.test.matchers;

import com.codepoetics.fluvius.api.scratchpad.Key;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class RecordingMatcher {
    private final Map<String, Object> recordedValues = new HashMap<String, Object>();

    public <T> Matcher<T> record(Key<T> key) {
        return this.record(key.getName());
    }

    public <T> Matcher<T> record(final String name) {
        return new BaseMatcher<T>(){

            public void describeTo(Description description) {
                description.appendText("(recorded as ").appendValue((Object)name).appendText(")");
            }

            public boolean matches(Object o) {
                RecordingMatcher.this.recordedValues.put(name, o);
                return true;
            }
        };
    }

    public <T> Matcher<T> equalsRecorded(Key<T> key) {
        return this.equalsRecorded(key.getName());
    }

    public <T> Matcher<T> equalsRecorded(final String name) {
        return new BaseMatcher<T>(){

            public boolean matches(Object o) {
                return RecordingMatcher.this.recordedValues.containsKey(name) && RecordingMatcher.this.recordedValues.get(name).equals(o);
            }

            public void describeTo(Description description) {
                description.appendText("equals value recorded as ").appendValue((Object)name);
                if (RecordingMatcher.this.recordedValues.containsKey(name)) {
                    description.appendText(" (").appendValue(RecordingMatcher.this.recordedValues.get(name)).appendText(")");
                } else {
                    description.appendText(" (no value recorded)");
                }
            }
        };
    }
}

