/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.fluvius.test.matchers;

import com.codepoetics.fluvius.test.matchers.IndentationControl;
import com.codepoetics.fluvius.test.matchers.PropertyDescriber;
import com.codepoetics.fluvius.test.matchers.PropertyMismatchDescriber;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

abstract class BasePropertyMatcher<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final String entityType;

    protected BasePropertyMatcher(String entityType) {
        this.entityType = entityType;
    }

    protected boolean propertyMatches(String propertyName, T propertyValue, Matcher<? super T> matcher, Description description) {
        if (matcher == null) {
            return true;
        }
        if (matcher.matches(propertyValue)) {
            return true;
        }
        IndentationControl.newline(description).appendText(propertyName).appendText(": ");
        IndentationControl.indent();
        matcher.describeMismatch(propertyValue, description);
        IndentationControl.outdent();
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("A ").appendText(this.entityType);
        IndentationControl.indent();
        this.describeProperties(new PropertyDescriber(description));
        IndentationControl.outdent();
    }

    protected abstract void describeProperties(PropertyDescriber var1);

    protected abstract void checkProperties(T var1, PropertyMismatchDescriber var2);

    protected boolean matchesSafely(T t, Description description) {
        PropertyMismatchDescriber mismatchDescriber = new PropertyMismatchDescriber(description);
        this.checkProperties(t, mismatchDescriber);
        return mismatchDescriber.result();
    }
}

