/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.fluvius.test.matchers;

import com.codepoetics.fluvius.test.matchers.IndentationControl;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

final class PropertyMismatchDescriber {
    private final Description description;
    private boolean matches = true;

    PropertyMismatchDescriber(Description description) {
        this.description = description;
    }

    public <T> PropertyMismatchDescriber check(String propertyName, T propertyValue, Matcher<? super T> matcher) {
        if (matcher == null) {
            return this;
        }
        if (matcher.matches(propertyValue)) {
            return this;
        }
        this.matches = false;
        IndentationControl.newline(this.description).appendText(propertyName).appendText(": ");
        IndentationControl.indent();
        matcher.describeMismatch(propertyValue, this.description);
        IndentationControl.outdent();
        return this;
    }

    public boolean result() {
        return this.matches;
    }
}

