/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.fluvius.test.matchers;

import com.codepoetics.fluvius.test.matchers.IndentationControl;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

final class PropertyDescriber {
    private final Description description;

    PropertyDescriber(Description description) {
        this.description = description;
    }

    public PropertyDescriber describeProperty(String name, Matcher<?> matcher) {
        if (matcher == null) {
            return this;
        }
        IndentationControl.newline(this.description).appendText(name).appendText(": ");
        matcher.describeTo(this.description);
        return this;
    }

    public <T> PropertyDescriber describeProperty(String name, List<Matcher<? super T>> matchers) {
        if (matchers == null || matchers.isEmpty()) {
            return this;
        }
        IndentationControl.newline(this.description).appendText(name).appendText(":");
        IndentationControl.indent();
        for (Matcher<T> matcher : matchers) {
            IndentationControl.newline(this.description).appendDescriptionOf(matcher);
        }
        IndentationControl.outdent();
        return this;
    }

    public Description getDescription() {
        return this.description;
    }
}

