/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.fluvius.test.matchers;

import com.codepoetics.fluvius.api.tracing.FlowStepType;
import com.codepoetics.fluvius.api.tracing.TraceMap;
import com.codepoetics.fluvius.test.matchers.BasePropertyMatcher;
import com.codepoetics.fluvius.test.matchers.PropertyDescriber;
import com.codepoetics.fluvius.test.matchers.PropertyMismatchDescriber;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class ATraceMap
extends BasePropertyMatcher<TraceMap> {
    private final Matcher<? super FlowStepType> typeMatcher;
    private Matcher<? super UUID> idMatcher;
    private Matcher<String> descriptionMatcher;
    private Matcher<Iterable<? extends String>> requiredKeysMatcher;
    private Matcher<String> providedKeyMatcher;
    private List<Matcher<? super TraceMap>> childMatchers;

    private ATraceMap(Matcher<FlowStepType> typeMatcher) {
        super("TraceMap");
        this.typeMatcher = typeMatcher;
    }

    public static ATraceMap ofType(FlowStepType type) {
        return new ATraceMap((Matcher<FlowStepType>)Matchers.equalTo((Object)type));
    }

    public static ATraceMap ofAnyType() {
        return new ATraceMap((Matcher<FlowStepType>)Matchers.any(FlowStepType.class));
    }

    public ATraceMap withId(UUID expected) {
        return this.withId((Matcher<? super UUID>)Matchers.equalTo((Object)expected));
    }

    public ATraceMap withId(Matcher<? super UUID> idMatcher) {
        this.idMatcher = idMatcher;
        return this;
    }

    public ATraceMap withDescription(String expected) {
        return this.withDescription((Matcher<String>)Matchers.equalTo((Object)expected));
    }

    public ATraceMap withDescription(Matcher<String> descriptionMatcher) {
        this.descriptionMatcher = descriptionMatcher;
        return this;
    }

    public ATraceMap withRequiredKeys(String ... requiredKeys) {
        return this.withRequiredKeys((Matcher<Iterable<? extends String>>)Matchers.containsInAnyOrder((Object[])requiredKeys));
    }

    @SafeVarargs
    public final ATraceMap withRequiredKeys(Matcher<? super String> ... keyMatchers) {
        return this.withRequiredKeys((Matcher<Iterable<? extends String>>)Matchers.containsInAnyOrder(Arrays.asList(keyMatchers)));
    }

    public ATraceMap withRequiredKeys(Collection<String> requiredKeys) {
        return this.withRequiredKeys((Matcher<Iterable<? extends String>>)Matchers.containsInAnyOrder((Object[])requiredKeys.toArray(new String[requiredKeys.size()])));
    }

    public ATraceMap withRequiredKeys(Matcher<Iterable<? extends String>> requiredKeysMatcher) {
        this.requiredKeysMatcher = requiredKeysMatcher;
        return this;
    }

    public ATraceMap withProvidedKey(String expected) {
        return this.withProvidedKey((Matcher<String>)Matchers.equalTo((Object)expected));
    }

    public ATraceMap withProvidedKey(Matcher<String> providedKeyMatcher) {
        this.providedKeyMatcher = providedKeyMatcher;
        return this;
    }

    @SafeVarargs
    public final ATraceMap withChildren(Matcher<? super TraceMap> ... traceMapMatchers) {
        return this.withChildren(Arrays.asList(traceMapMatchers));
    }

    public ATraceMap withChildren(List<Matcher<? super TraceMap>> childMatchers) {
        this.childMatchers = childMatchers;
        return this;
    }

    @Override
    protected void describeProperties(PropertyDescriber describer) {
        describer.describeProperty("type", this.typeMatcher).describeProperty("id", this.idMatcher).describeProperty("description", this.descriptionMatcher).describeProperty("requiredKeys", this.requiredKeysMatcher).describeProperty("providedKey", this.providedKeyMatcher).describeProperty("children", this.childMatchers);
    }

    @Override
    protected void checkProperties(TraceMap traceMap, PropertyMismatchDescriber describer) {
        describer.check("type", traceMap.getType(), this.typeMatcher).check("id", traceMap.getStepId(), this.idMatcher).check("description", traceMap.getDescription(), this.descriptionMatcher).check("requiredKeys", traceMap.getRequiredKeys(), this.requiredKeysMatcher).check("providedKey", traceMap.getProvidedKey(), this.providedKeyMatcher).check("children", traceMap.getChildren(), this.childMatchers == null ? null : Matchers.contains(this.childMatchers));
    }
}

