/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.fluvius.test.matchers;

import com.codepoetics.fluvius.api.history.FlowEvent;
import com.codepoetics.fluvius.api.history.FlowHistory;
import com.codepoetics.fluvius.api.tracing.TraceMap;
import com.codepoetics.fluvius.test.matchers.BasePropertyMatcher;
import com.codepoetics.fluvius.test.matchers.PropertyDescriber;
import com.codepoetics.fluvius.test.matchers.PropertyMismatchDescriber;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class AFlowHistory<T>
extends BasePropertyMatcher<FlowHistory<T>> {
    private final Matcher<? super UUID> flowIdMatcher;
    private Matcher<? super TraceMap> traceMapMatcher;
    private List<Matcher<? super FlowEvent<T>>> eventMatchers;

    public static <T> AFlowHistory<T> withAnyFlowId() {
        return AFlowHistory.withFlowId((Matcher<? super UUID>)Matchers.any(UUID.class));
    }

    public static <T> AFlowHistory<T> withFlowId(UUID expected) {
        return AFlowHistory.withFlowId((Matcher<? super UUID>)Matchers.equalTo((Object)expected));
    }

    public static <T> AFlowHistory<T> withFlowId(Matcher<? super UUID> flowIdMatcher) {
        return new AFlowHistory<T>(flowIdMatcher);
    }

    private AFlowHistory(Matcher<? super UUID> flowIdMatcher) {
        super("FlowHistory");
        this.flowIdMatcher = flowIdMatcher;
    }

    public AFlowHistory<T> withTraceMap(Matcher<? super TraceMap> traceMapMatcher) {
        this.traceMapMatcher = traceMapMatcher;
        return this;
    }

    @SafeVarargs
    public final AFlowHistory<T> withEventHistory(Matcher<? super FlowEvent<T>> ... eventMatchers) {
        return this.withEventHistory(Arrays.asList(eventMatchers));
    }

    public AFlowHistory<T> withEventHistory(List<Matcher<? super FlowEvent<T>>> eventMatchers) {
        this.eventMatchers = eventMatchers;
        return this;
    }

    @Override
    protected void describeProperties(PropertyDescriber describer) {
        describer.describeProperty("flowId", this.flowIdMatcher).describeProperty("traceMap", this.traceMapMatcher).describeProperty("eventHistory", this.eventMatchers);
    }

    @Override
    protected void checkProperties(FlowHistory<T> flowHistory, PropertyMismatchDescriber describer) {
        describer.check("flowId", flowHistory.getFlowId(), this.flowIdMatcher).check("traceMap", flowHistory.getTraceMap(), this.traceMapMatcher).check("eventHistory", flowHistory.getEventHistory(), this.eventMatchers == null ? null : Matchers.contains(this.eventMatchers));
    }
}

