/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.fluvius.test.builders;

import com.codepoetics.fluvius.api.tracing.FlowStepType;
import com.codepoetics.fluvius.api.tracing.TraceMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public final class TestTraceMap
implements TraceMap {
    private final FlowStepType type;
    private UUID stepId = UUID.randomUUID();
    private Set<String> requiredKeys;
    private String providedKey;
    private String description;
    private List<TraceMap> children;

    public static TestTraceMap ofType(FlowStepType type) {
        return new TestTraceMap(type);
    }

    private TestTraceMap(FlowStepType type) {
        this.type = type;
    }

    public TestTraceMap withId(UUID id) {
        this.stepId = id;
        return this;
    }

    public UUID getStepId() {
        return this.stepId;
    }

    public TestTraceMap withRequiredKeys(String ... requiredKeys) {
        return this.withRequiredKeys(new HashSet<String>(Arrays.asList(requiredKeys)));
    }

    public TestTraceMap withRequiredKeys(Set<String> requiredKeys) {
        this.requiredKeys = requiredKeys;
        return this;
    }

    public Set<String> getRequiredKeys() {
        return this.requiredKeys;
    }

    public TestTraceMap withProvidedKey(String providedKey) {
        this.providedKey = providedKey;
        return this;
    }

    public String getProvidedKey() {
        return this.providedKey;
    }

    public TestTraceMap withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public FlowStepType getType() {
        return this.type;
    }

    public TestTraceMap withChildren(TraceMap ... children) {
        return this.withChildren(Arrays.asList(children));
    }

    public TestTraceMap withChildren(List<TraceMap> children) {
        this.children = children;
        return this;
    }

    public List<TraceMap> getChildren() {
        return this.children;
    }
}

