/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.fluvius.test.builders;

import com.codepoetics.fluvius.api.history.FlowEvent;
import com.codepoetics.fluvius.api.history.FlowEventTranslator;
import com.codepoetics.fluvius.api.history.FlowHistory;
import com.codepoetics.fluvius.api.tracing.TraceMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public final class TestFlowHistory<T>
implements FlowHistory<T> {
    private final UUID flowId;
    private TraceMap traceMap;
    private List<FlowEvent<T>> eventHistory = Collections.emptyList();

    public static <T> TestFlowHistory<T> withFlowId(UUID flowId) {
        return new TestFlowHistory<T>(flowId);
    }

    private TestFlowHistory(UUID flowId) {
        this.flowId = flowId;
    }

    public UUID getFlowId() {
        return this.flowId;
    }

    public TestFlowHistory<T> withTraceMap(TraceMap traceMap) {
        this.traceMap = traceMap;
        return this;
    }

    public TraceMap getTraceMap() {
        return this.traceMap;
    }

    @SafeVarargs
    public final TestFlowHistory<T> withEventHistory(FlowEvent<? extends T> ... events) {
        return this.withEventHistory(Arrays.asList(events));
    }

    public TestFlowHistory<T> withEventHistory(List<FlowEvent<T>> events) {
        this.eventHistory = events;
        return this;
    }

    public List<FlowEvent<T>> getEventHistory() {
        return this.eventHistory;
    }

    public <V> List<V> getTranslatedEventHistory(FlowEventTranslator<T, V> translator) {
        ArrayList<Object> result = new ArrayList<Object>(this.eventHistory.size());
        for (FlowEvent<T> event : this.eventHistory) {
            result.add(event.translate(translator));
        }
        return result;
    }
}

