/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.fluvius.test.mocks;

import com.codepoetics.fluvius.api.scratchpad.Key;
import com.codepoetics.fluvius.api.scratchpad.KeyValue;
import com.codepoetics.fluvius.api.scratchpad.Scratchpad;
import com.codepoetics.fluvius.api.scratchpad.ScratchpadStorage;
import com.codepoetics.fluvius.api.tracing.TraceEventListener;
import com.codepoetics.fluvius.test.matchers.AMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;

public final class MockTraceEventListener
implements TraceEventListener {
    private final TraceEventListener innerMock = (TraceEventListener)Mockito.mock(TraceEventListener.class);
    private final InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.innerMock});
    private Matcher<UUID> flowIdMatcher = org.hamcrest.Matchers.any(UUID.class);
    private Matcher<UUID> lastStepIdMatcher = org.hamcrest.Matchers.any(UUID.class);

    public MockTraceEventListener forFlow(UUID flowId) {
        return this.forFlow((Matcher<UUID>)org.hamcrest.Matchers.equalTo((Object)flowId));
    }

    public MockTraceEventListener forFlow(Matcher<UUID> flowIdMatcher) {
        this.flowIdMatcher = flowIdMatcher;
        return this;
    }

    public void stepStarted(UUID flowId, UUID stepId, Map<String, Object> scratchpadState) {
        this.innerMock.stepStarted(flowId, stepId, scratchpadState);
    }

    public void stepSucceeded(UUID flowId, UUID stepId, Object result) {
        this.innerMock.stepSucceeded(flowId, stepId, result);
    }

    public void stepFailed(UUID flowId, UUID stepId, Exception exception) {
        this.innerMock.stepFailed(flowId, stepId, exception);
    }

    public MockTraceEventListener verifyStepStarted(Matcher<UUID> stepIdMatcher, KeyValue ... scratchpadContents) {
        final LinkedHashMap scratchpadState = new LinkedHashMap();
        ScratchpadStorage storage = new ScratchpadStorage(){

            public <T> void storeSuccess(Key<T> key, T value) {
                scratchpadState.put(key.getName(), value);
            }

            public void storeFailure(Key<?> key, Throwable reason) {
                scratchpadState.put(key.getName(), reason);
            }
        };
        for (KeyValue keyValue : scratchpadContents) {
            keyValue.store(storage);
        }
        return this.verifyStepStarted(stepIdMatcher, (Matcher<Map<String, Object>>)AMap.containing(scratchpadState));
    }

    public MockTraceEventListener verifyStepStarted(Matcher<UUID> stepIdMatcher, Scratchpad scratchpad) {
        LinkedHashMap scratchpadState = new LinkedHashMap();
        for (Map.Entry entry : scratchpad.toMap().entrySet()) {
            scratchpadState.put(((Key)entry.getKey()).getName(), entry.getValue());
        }
        return this.verifyStepStarted(stepIdMatcher, (Matcher<Map<String, Object>>)AMap.containing(scratchpadState));
    }

    public MockTraceEventListener verifyStepStarted(Matcher<UUID> stepIdMatcher, Matcher<Map<String, Object>> scratchpadState) {
        this.lastStepIdMatcher = stepIdMatcher;
        ((TraceEventListener)this.inOrder.verify((Object)this.innerMock)).stepStarted((UUID)Matchers.argThat(this.flowIdMatcher), (UUID)Matchers.argThat(stepIdMatcher), (Map)Matchers.argThat(scratchpadState));
        return this;
    }

    public MockTraceEventListener verifyStepSucceeded(Matcher<UUID> stepIdMatcher) {
        return this.verifyStepSucceeded(stepIdMatcher, (Matcher<Object>)org.hamcrest.Matchers.notNullValue());
    }

    public MockTraceEventListener verifyStepSucceeded(Matcher<UUID> stepIdMatcher, Object result) {
        return this.verifyStepSucceeded(stepIdMatcher, (Matcher<Object>)org.hamcrest.Matchers.equalTo((Object)result));
    }

    public MockTraceEventListener verifyStepSucceeded(Matcher<UUID> stepIdMatcher, Matcher<Object> resultMatcher) {
        ((TraceEventListener)this.inOrder.verify((Object)this.innerMock)).stepSucceeded((UUID)Matchers.argThat(this.flowIdMatcher), (UUID)Matchers.argThat(stepIdMatcher), Matchers.argThat(resultMatcher));
        return this;
    }

    public MockTraceEventListener andSucceeded() {
        return this.verifyStepSucceeded(this.lastStepIdMatcher);
    }

    public MockTraceEventListener andSucceeded(Object result) {
        return this.verifyStepSucceeded(this.lastStepIdMatcher, result);
    }

    public MockTraceEventListener andSucceeded(Matcher<Object> resultMatcher) {
        return this.verifyStepSucceeded(this.lastStepIdMatcher, resultMatcher);
    }

    public MockTraceEventListener verifyStepFailed(Matcher<UUID> stepIdMatcher) {
        return this.verifyStepFailed(stepIdMatcher, (Matcher<Exception>)org.hamcrest.Matchers.any(Exception.class));
    }

    public MockTraceEventListener verifyStepFailed(Matcher<UUID> stepIdMatcher, Exception reason) {
        return this.verifyStepFailed(stepIdMatcher, (Matcher<Exception>)org.hamcrest.Matchers.equalTo((Object)reason));
    }

    public MockTraceEventListener verifyStepFailed(Matcher<UUID> stepIdMatcher, Matcher<Exception> reasonMatcher) {
        ((TraceEventListener)this.inOrder.verify((Object)this.innerMock)).stepFailed((UUID)Matchers.argThat(this.flowIdMatcher), (UUID)Matchers.argThat(stepIdMatcher), (Exception)Matchers.argThat(reasonMatcher));
        return this;
    }

    public MockTraceEventListener andFailed() {
        return this.verifyStepFailed(this.lastStepIdMatcher);
    }

    public MockTraceEventListener andFailed(Exception reason) {
        return this.verifyStepFailed(this.lastStepIdMatcher, reason);
    }

    public MockTraceEventListener andFailed(Matcher<Exception> reasonMatcher) {
        return this.verifyStepFailed(this.lastStepIdMatcher, reasonMatcher);
    }
}

