/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.fluvius.test.matchers;

import com.codepoetics.fluvius.api.history.FlowEvent;
import com.codepoetics.fluvius.test.matchers.IndentationControl;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class AnEventHistory<T>
extends TypeSafeDiagnosingMatcher<List<FlowEvent<T>>> {
    private final List<Matcher<FlowEvent<T>>> matchers;

    @SafeVarargs
    public static <T> AnEventHistory<T> of(Matcher<FlowEvent<T>> ... matchers) {
        return new AnEventHistory<T>(Arrays.asList(matchers));
    }

    private AnEventHistory(List<Matcher<FlowEvent<T>>> matchers) {
        this.matchers = matchers;
    }

    protected boolean matchesSafely(List<FlowEvent<T>> flowEvents, Description description) {
        if (flowEvents.size() != this.matchers.size()) {
            description.appendText("history contained ").appendText(Integer.toString(flowEvents.size())).appendText(" events");
            return false;
        }
        boolean matched = true;
        for (int i = 0; i < this.matchers.size(); ++i) {
            FlowEvent<T> flowEvent;
            Matcher<FlowEvent<T>> matcher = this.matchers.get(i);
            if (matcher.matches(flowEvent = flowEvents.get(i))) continue;
            matched = false;
            IndentationControl.newline(description).appendText(Integer.toString(i)).appendText(": ");
            IndentationControl.indent();
            matcher.describeMismatch(flowEvent, description);
            IndentationControl.outdent();
        }
        return matched;
    }

    public void describeTo(Description description) {
        description.appendText("A flow event history:");
        IndentationControl.indent();
        for (int i = 0; i < this.matchers.size(); ++i) {
            IndentationControl.newline(description).appendText(Integer.toString(i)).appendText(": ").appendDescriptionOf((SelfDescribing)this.matchers.get(i));
        }
        IndentationControl.outdent();
    }
}

