/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.fluvius.test.matchers;

import com.codepoetics.fluvius.api.history.FlowEvent;
import com.codepoetics.fluvius.api.history.FlowEventTranslator;
import com.codepoetics.fluvius.api.history.StepFailedEvent;
import com.codepoetics.fluvius.api.history.StepStartedEvent;
import com.codepoetics.fluvius.api.history.StepSucceededEvent;
import com.codepoetics.fluvius.test.matchers.BasePropertyMatcher;
import com.codepoetics.fluvius.test.matchers.PropertyDescriber;
import com.codepoetics.fluvius.test.matchers.PropertyMismatchDescriber;
import java.util.Map;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class AFlowEvent<T>
extends BasePropertyMatcher<FlowEvent<T>> {
    private final Class<? extends FlowEvent> expectedEventType;
    private Matcher<? super UUID> flowIdMatcher;
    private Matcher<? super UUID> stepIdMatcher;
    private Matcher<? super Long> timestampMatcher;
    private Matcher<? super Map<String, T>> scratchpadStateMatcher;
    private Matcher<? super T> resultMatcher;
    private Matcher<? super T> reasonMatcher;

    public static <T> AFlowEvent<T> stepStarted() {
        return new AFlowEvent<T>(StepStartedEvent.class);
    }

    public static <T> AFlowEvent<T> stepStarted(Map<String, T> scratchpadState) {
        return AFlowEvent.stepStarted(Matchers.equalTo(scratchpadState));
    }

    public static <T> AFlowEvent<T> stepStarted(Matcher<? super Map<String, T>> scratchpadStateMatcher) {
        AFlowEvent<T> flowEventMatcher = AFlowEvent.stepStarted();
        flowEventMatcher.scratchpadStateMatcher = scratchpadStateMatcher;
        return flowEventMatcher;
    }

    public static <T> AFlowEvent<T> stepSucceeded() {
        return new AFlowEvent<T>(StepSucceededEvent.class);
    }

    public static <T> AFlowEvent<T> stepSucceeded(T result) {
        return AFlowEvent.stepSucceeded(Matchers.equalTo(result));
    }

    public static <T> AFlowEvent<T> stepSucceeded(Matcher<? super T> resultMatcher) {
        AFlowEvent<T> flowEventMatcher = AFlowEvent.stepSucceeded();
        flowEventMatcher.resultMatcher = resultMatcher;
        return flowEventMatcher;
    }

    public static <T> AFlowEvent<T> stepFailed() {
        return new AFlowEvent<T>(StepFailedEvent.class);
    }

    public static <T> AFlowEvent<T> stepFailed(T result) {
        return AFlowEvent.stepFailed(Matchers.equalTo(result));
    }

    public static <T> AFlowEvent<T> stepFailed(Matcher<? super T> reasonMatcher) {
        AFlowEvent<T> flowEventMatcher = AFlowEvent.stepFailed();
        flowEventMatcher.reasonMatcher = reasonMatcher;
        return flowEventMatcher;
    }

    private AFlowEvent(Class<? extends FlowEvent> expectedEventType) {
        super(expectedEventType.getSimpleName());
        this.expectedEventType = expectedEventType;
    }

    public AFlowEvent<T> withFlowId(UUID flowId) {
        return this.withFlowId((Matcher<UUID>)Matchers.equalTo((Object)flowId));
    }

    public AFlowEvent<T> withFlowId(Matcher<? super UUID> flowIdMatcher) {
        this.flowIdMatcher = flowIdMatcher;
        return this;
    }

    public AFlowEvent<T> withStepId(UUID stepId) {
        return this.withStepId((Matcher<UUID>)Matchers.equalTo((Object)stepId));
    }

    public AFlowEvent<T> withStepId(Matcher<? super UUID> stepIdMatcher) {
        this.stepIdMatcher = stepIdMatcher;
        return this;
    }

    public AFlowEvent<T> withTimestamp(long timestamp) {
        return this.withTimestamp((Matcher<Long>)Matchers.equalTo((Object)timestamp));
    }

    public AFlowEvent<T> withTimestamp(Matcher<? super Long> timestampMatcher) {
        this.timestampMatcher = timestampMatcher;
        return this;
    }

    @Override
    protected void describeProperties(PropertyDescriber describer) {
        describer.describeProperty("flowId", this.flowIdMatcher).describeProperty("stepId", this.stepIdMatcher).describeProperty("timestamp", this.timestampMatcher).describeProperty("scratchpadState", this.scratchpadStateMatcher).describeProperty("result", this.resultMatcher).describeProperty("reason", this.reasonMatcher);
    }

    @Override
    protected void checkProperties(FlowEvent<T> flowEvent, final PropertyMismatchDescriber describer) {
        describer.check("type", flowEvent, Matchers.instanceOf(this.expectedEventType)).check("flowId", flowEvent.getFlowId(), this.flowIdMatcher).check("stepId", flowEvent.getStepId(), this.stepIdMatcher).check("timestamp", flowEvent.getTimestamp(), this.timestampMatcher);
        flowEvent.translate(new FlowEventTranslator<T, PropertyMismatchDescriber>(){

            public PropertyMismatchDescriber translateStepStartedEvent(StepStartedEvent<T> event) {
                return describer.check("scratchpadState", event.getScratchpadState(), AFlowEvent.this.scratchpadStateMatcher);
            }

            public PropertyMismatchDescriber translateStepSucceededEvent(StepSucceededEvent<T> event) {
                return describer.check("result", event.getResult(), AFlowEvent.this.resultMatcher);
            }

            public PropertyMismatchDescriber translateStepFailedEvent(StepFailedEvent<T> event) {
                return describer.check("reason", event.getReason(), AFlowEvent.this.reasonMatcher);
            }
        });
    }
}

