/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import java.util.Collection;
import java.util.Map;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UnusedWebdriversCleanupThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(UnusedWebdriversCleanupThread.class);
    private final Collection<Thread> allWebDriverThreads;
    private final Map<Long, WebDriver> threadWebDriver;
    private final Map<Long, SelenideProxyServer> threadProxyServer;
    private final Map<Long, DownloadsFolder> threadDownloadsFolder;

    UnusedWebdriversCleanupThread(Collection<Thread> allWebDriverThreads, Map<Long, WebDriver> threadWebDriver, Map<Long, SelenideProxyServer> threadProxyServer, Map<Long, DownloadsFolder> threadDownloadsFolder) {
        this.allWebDriverThreads = allWebDriverThreads;
        this.threadWebDriver = threadWebDriver;
        this.threadProxyServer = threadProxyServer;
        this.threadDownloadsFolder = threadDownloadsFolder;
        this.setDaemon(true);
        this.setName("Webdrivers killer thread");
    }

    @Override
    public void run() {
        while (true) {
            this.closeUnusedWebdrivers();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    private void closeUnusedWebdrivers() {
        for (Thread thread : this.allWebDriverThreads) {
            if (thread.isAlive()) continue;
            log.info("Thread {} is dead. Let's close webdriver {}", (Object)thread.getId(), (Object)this.threadWebDriver.get(thread.getId()));
            this.closeWebDriver(thread);
        }
    }

    private void closeWebDriver(Thread thread) {
        this.allWebDriverThreads.remove(thread);
        WebDriver driver = this.threadWebDriver.remove(thread.getId());
        if (driver == null) {
            log.info("No webdriver found for thread: {} - nothing to close", (Object)thread.getId());
        } else {
            this.quitSafely(thread.getId(), driver);
        }
        SelenideProxyServer proxy = this.threadProxyServer.remove(thread.getId());
        if (proxy != null) {
            proxy.shutdown();
        }
        this.threadDownloadsFolder.remove(thread.getId());
    }

    private void quitSafely(long threadId, WebDriver driver) {
        try {
            driver.quit();
        }
        catch (NoSuchSessionException e) {
            log.debug("Webdriver for thread {} has been closed meanwhile", (Object)threadId, (Object)e);
        }
        catch (WebDriverException e) {
            if ("The driver server has unexpectedly died!".equalsIgnoreCase(e.getMessage())) {
                log.debug("Webdriver for thread {} has been closed meanwhile", (Object)threadId, (Object)e);
            }
            log.error("Failed to close webdriver for thread {}", (Object)threadId, (Object)e);
        }
    }
}

