/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.SelenideDriver;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import com.codeborne.selenide.webdriver.BrowserResizer;
import com.codeborne.selenide.webdriver.ChromeDriverFactory;
import com.codeborne.selenide.webdriver.DefaultDriverFactory;
import com.codeborne.selenide.webdriver.EdgeDriverFactory;
import com.codeborne.selenide.webdriver.FirefoxDriverFactory;
import com.codeborne.selenide.webdriver.HtmlUnitDriverFactory;
import com.codeborne.selenide.webdriver.InternetExplorerDriverFactory;
import com.codeborne.selenide.webdriver.JBrowserDriverFactory;
import com.codeborne.selenide.webdriver.LegacyFirefoxDriverFactory;
import com.codeborne.selenide.webdriver.OperaDriverFactory;
import com.codeborne.selenide.webdriver.PhantomJsDriverFactory;
import com.codeborne.selenide.webdriver.RemoteDriverFactory;
import com.codeborne.selenide.webdriver.SafariDriverFactory;
import com.codeborne.selenide.webdriver.WebDriverBinaryManager;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;

public class WebDriverFactory {
    private static final Logger log = Logger.getLogger(WebDriverFactory.class.getName());
    protected List<AbstractDriverFactory> factories = Arrays.asList(new RemoteDriverFactory(), new ChromeDriverFactory(), new LegacyFirefoxDriverFactory(), new FirefoxDriverFactory(), new HtmlUnitDriverFactory(), new EdgeDriverFactory(), new InternetExplorerDriverFactory(), new PhantomJsDriverFactory(), new OperaDriverFactory(), new SafariDriverFactory(), new JBrowserDriverFactory());
    protected WebDriverBinaryManager webDriverBinaryManager = new WebDriverBinaryManager();
    protected BrowserResizer browserResizer = new BrowserResizer();

    public WebDriver createWebDriver(Config config, Proxy proxy) {
        log.config("browser=" + config.browser());
        log.config("browser.version=" + config.browserVersion());
        log.config("remote=" + config.remote());
        log.config("browserSize=" + config.browserSize());
        log.config("startMaximized=" + config.startMaximized());
        Browser browser = new Browser(config.browser(), config.headless());
        if (config.driverManagerEnabled() && config.remote() == null) {
            this.webDriverBinaryManager.setupBinaryPath(browser);
        }
        WebDriver webdriver = this.factories.stream().filter(factory -> factory.supports(config, browser)).findAny().map(driverFactory -> driverFactory.create(config, proxy)).orElseGet(() -> new DefaultDriverFactory().create(config, proxy));
        webdriver = this.browserResizer.adjustBrowserSize(config, browser, webdriver);
        webdriver = this.browserResizer.adjustBrowserPosition(config, webdriver);
        this.logBrowserVersion(webdriver);
        log.info("Selenide v. " + SelenideDriver.class.getPackage().getImplementationVersion());
        this.logSeleniumInfo(config);
        return webdriver;
    }

    protected void logSeleniumInfo(Config config) {
        if (config.remote() == null) {
            BuildInfo seleniumInfo = new BuildInfo();
            log.info("Selenium WebDriver v. " + seleniumInfo.getReleaseLabel() + " build time: " + seleniumInfo.getBuildTime());
        }
    }

    protected void logBrowserVersion(WebDriver webdriver) {
        if (webdriver instanceof HasCapabilities) {
            Capabilities capabilities = ((HasCapabilities)webdriver).getCapabilities();
            log.info("BrowserName=" + capabilities.getBrowserName() + " Version=" + capabilities.getVersion() + " Platform=" + capabilities.getPlatform());
        } else {
            log.info("BrowserName=" + webdriver.getClass().getName());
        }
    }
}

