/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelectorMode;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class WebElementSelector {
    public static WebElementSelector instance = new WebElementSelector();
    protected String sizzleSource;

    public WebElement findElement(Driver driver, SearchContext context, By selector) {
        this.checkThatXPathNotStartingFromSlash(context, selector);
        if (driver.config().selectorMode() == SelectorMode.CSS || !(selector instanceof By.ByCssSelector)) {
            return context.findElement(selector);
        }
        List<WebElement> webElements = this.evaluateSizzleSelector(driver, context, (By.ByCssSelector)selector);
        return webElements.isEmpty() ? null : webElements.get(0);
    }

    public List<WebElement> findElements(Driver driver, SearchContext context, By selector) {
        this.checkThatXPathNotStartingFromSlash(context, selector);
        if (driver.config().selectorMode() == SelectorMode.CSS || !(selector instanceof By.ByCssSelector)) {
            return context.findElements(selector);
        }
        return this.evaluateSizzleSelector(driver, context, (By.ByCssSelector)selector);
    }

    protected void checkThatXPathNotStartingFromSlash(SearchContext context, By selector) {
        if (context instanceof WebElement && selector instanceof By.ByXPath && selector.toString().startsWith("By.xpath: /")) {
            throw new IllegalArgumentException("XPath starting from / searches from root");
        }
    }

    protected List<WebElement> evaluateSizzleSelector(Driver driver, SearchContext context, By.ByCssSelector sizzleCssSelector) {
        this.injectSizzleIfNeeded(driver);
        String sizzleSelector = sizzleCssSelector.toString().replace("By.selector: ", "").replace("By.cssSelector: ", "");
        if (context instanceof WebElement) {
            return (List)driver.executeJavaScript("return Sizzle(arguments[0], arguments[1])", sizzleSelector, context);
        }
        return (List)driver.executeJavaScript("return Sizzle(arguments[0])", sizzleSelector);
    }

    protected void injectSizzleIfNeeded(Driver driver) {
        if (!this.sizzleLoaded(driver).booleanValue()) {
            this.injectSizzle(driver);
        }
    }

    protected Boolean sizzleLoaded(Driver driver) {
        try {
            return (Boolean)driver.executeJavaScript("return typeof Sizzle != 'undefined'", new Object[0]);
        }
        catch (WebDriverException e) {
            return false;
        }
    }

    protected synchronized void injectSizzle(Driver driver) {
        if (this.sizzleSource == null) {
            try {
                this.sizzleSource = IOUtils.toString((URL)Thread.currentThread().getContextClassLoader().getResource("sizzle.js"), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot load sizzle.js from classpath", e);
            }
        }
        driver.executeJavaScript(this.sizzleSource, new Object[0]);
    }
}

