/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.proxy.SelenideProxyServer;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.openqa.selenium.WebDriver;

class UnusedWebdriversCleanupThread
extends Thread {
    private static final Logger log = Logger.getLogger(UnusedWebdriversCleanupThread.class.getName());
    private final Collection<Thread> allWebDriverThreads;
    private final Map<Long, WebDriver> threadWebDriver;
    private final Map<Long, SelenideProxyServer> threadProxyServer;

    UnusedWebdriversCleanupThread(Collection<Thread> allWebDriverThreads, Map<Long, WebDriver> threadWebDriver, Map<Long, SelenideProxyServer> threadProxyServer) {
        this.allWebDriverThreads = allWebDriverThreads;
        this.threadWebDriver = threadWebDriver;
        this.threadProxyServer = threadProxyServer;
        this.setDaemon(true);
        this.setName("Webdrivers killer thread");
    }

    @Override
    public void run() {
        while (true) {
            this.closeUnusedWebdrivers();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    private void closeUnusedWebdrivers() {
        for (Thread thread : this.allWebDriverThreads) {
            if (thread.isAlive()) continue;
            log.info("Thread " + thread.getId() + " is dead. Let's close webdriver " + this.threadWebDriver.get(thread.getId()));
            this.closeWebDriver(thread);
        }
    }

    private void closeWebDriver(Thread thread) {
        this.allWebDriverThreads.remove(thread);
        WebDriver driver = this.threadWebDriver.remove(thread.getId());
        if (driver == null) {
            log.info("No webdriver found for thread : " + thread.getId() + " - nothing to close");
        } else {
            driver.quit();
        }
        SelenideProxyServer proxy = this.threadProxyServer.remove(thread.getId());
        if (proxy != null) {
            proxy.shutdown();
        }
    }
}

