/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.impl.Randomizer;
import java.io.File;

public class Downloader {
    private final Randomizer random;

    public Downloader() {
        this(new Randomizer());
    }

    public Downloader(Randomizer random) {
        this.random = random;
    }

    public String randomFileName() {
        return this.random.text();
    }

    public File prepareTargetFile(Config config, String fileName) {
        File uniqueFolder = new File(config.reportsFolder(), this.random.text());
        if (uniqueFolder.exists()) {
            throw new IllegalStateException("Unbelievable! Unique folder already exists: " + uniqueFolder.getAbsolutePath());
        }
        if (!uniqueFolder.mkdirs()) {
            throw new RuntimeException("Failed to create folder " + uniqueFolder.getAbsolutePath());
        }
        return new File(uniqueFolder, fileName);
    }
}

