/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.SelenideWait;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Function;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;

public class SelenideTargetLocator
implements WebDriver.TargetLocator {
    private final WebDriver webDriver;
    private final Config config;
    private final WebDriver.TargetLocator delegate;

    public SelenideTargetLocator(Config config, WebDriver webDriver) {
        this.config = config;
        this.webDriver = webDriver;
        this.delegate = webDriver.switchTo();
    }

    public WebDriver frame(int index) {
        try {
            return (WebDriver)this.Wait().until((Function)ExpectedConditions.frameToBeAvailableAndSwitchToIt((int)index));
        }
        catch (NoSuchElementException | TimeoutException e) {
            throw new NoSuchFrameException("No frame found with index: " + index, e);
        }
        catch (InvalidArgumentException e) {
            throw this.isFirefox62Bug(e) || this.isChrome75Error(e) ? new NoSuchFrameException("No frame found with index: " + index, (Throwable)e) : e;
        }
    }

    public WebDriver frame(String nameOrId) {
        try {
            return (WebDriver)this.Wait().until((Function)ExpectedConditions.frameToBeAvailableAndSwitchToIt((String)nameOrId));
        }
        catch (NoSuchElementException | TimeoutException e) {
            throw new NoSuchFrameException("No frame found with id/name: " + nameOrId, e);
        }
        catch (InvalidArgumentException e) {
            throw this.isFirefox62Bug(e) ? new NoSuchFrameException("No frame found with id/name: " + nameOrId, (Throwable)e) : e;
        }
    }

    public WebDriver frame(WebElement frameElement) {
        try {
            return (WebDriver)this.Wait().until((Function)ExpectedConditions.frameToBeAvailableAndSwitchToIt((WebElement)frameElement));
        }
        catch (NoSuchElementException | TimeoutException e) {
            throw new NoSuchFrameException("No frame found with element: " + frameElement, e);
        }
        catch (InvalidArgumentException e) {
            throw this.isFirefox62Bug(e) ? new NoSuchFrameException("No frame found with element: " + frameElement, (Throwable)e) : e;
        }
    }

    private boolean isFirefox62Bug(InvalidArgumentException e) {
        return e.getMessage().contains("untagged enum FrameId");
    }

    private boolean isChrome75Error(InvalidArgumentException e) {
        return e.getMessage().contains("invalid argument: 'id' out of range");
    }

    public WebDriver parentFrame() {
        return this.delegate.parentFrame();
    }

    public WebDriver defaultContent() {
        return this.delegate.defaultContent();
    }

    public WebElement activeElement() {
        return this.delegate.activeElement();
    }

    public Alert alert() {
        try {
            return (Alert)this.Wait().until((Function)ExpectedConditions.alertIsPresent());
        }
        catch (TimeoutException e) {
            throw new NoAlertPresentException("Alert not found", (Throwable)e);
        }
    }

    public WebDriver innerFrame(String ... frames) {
        this.delegate.defaultContent();
        for (String frame : frames) {
            try {
                String selector = String.format("frame#%1$s,frame[name=%1$s],iframe#%1$s,iframe[name=%1$s]", frame);
                this.Wait().until((Function)SelenideTargetLocator.frameToBeAvailableAndSwitchToIt_fixed(By.cssSelector((String)selector)));
            }
            catch (NoSuchElementException | TimeoutException e) {
                throw new NoSuchFrameException("No frame found with id/name = " + frame, e);
            }
        }
        return this.webDriver;
    }

    private static ExpectedCondition<WebDriver> frameToBeAvailableAndSwitchToIt_fixed(final By locator) {
        return new ExpectedCondition<WebDriver>(){

            public WebDriver apply(WebDriver driver) {
                try {
                    return driver.switchTo().frame(driver.findElement(locator));
                }
                catch (NoSuchFrameException e) {
                    return null;
                }
                catch (WebDriverException e) {
                    return null;
                }
            }

            public String toString() {
                return "frame to be available: " + locator;
            }
        };
    }

    private static ExpectedCondition<WebDriver> windowToBeAvailableAndSwitchToIt(final String nameOrHandleOrTitle) {
        return new ExpectedCondition<WebDriver>(){

            public WebDriver apply(WebDriver driver) {
                try {
                    return driver.switchTo().window(nameOrHandleOrTitle);
                }
                catch (NoSuchWindowException windowWithNameOrHandleNotFound) {
                    try {
                        return SelenideTargetLocator.windowByTitle(driver, nameOrHandleOrTitle);
                    }
                    catch (NoSuchWindowException e) {
                        return null;
                    }
                }
            }

            public String toString() {
                return "window to be available by name or handle or title: " + nameOrHandleOrTitle;
            }
        };
    }

    private static ExpectedCondition<WebDriver> windowToBeAvailableAndSwitchToIt(final int index) {
        return new ExpectedCondition<WebDriver>(){

            public WebDriver apply(WebDriver driver) {
                try {
                    ArrayList windowHandles = new ArrayList(driver.getWindowHandles());
                    return driver.switchTo().window((String)windowHandles.get(index));
                }
                catch (IndexOutOfBoundsException windowWithIndexNotFound) {
                    return null;
                }
            }

            public String toString() {
                return "window to be available by index: " + index;
            }
        };
    }

    public WebDriver window(int index) {
        try {
            return (WebDriver)this.Wait().until((Function)SelenideTargetLocator.windowToBeAvailableAndSwitchToIt(index));
        }
        catch (TimeoutException e) {
            throw new NoSuchWindowException("No window found with index: " + index, (Throwable)e);
        }
    }

    public WebDriver window(String nameOrHandleOrTitle) {
        try {
            return (WebDriver)this.Wait().until((Function)SelenideTargetLocator.windowToBeAvailableAndSwitchToIt(nameOrHandleOrTitle));
        }
        catch (TimeoutException e) {
            throw new NoSuchWindowException("No window found with name or handle or title: " + nameOrHandleOrTitle, (Throwable)e);
        }
    }

    protected static WebDriver windowByTitle(WebDriver driver, String title) {
        Set windowHandles = driver.getWindowHandles();
        for (String windowHandle : windowHandles) {
            driver.switchTo().window(windowHandle);
            if (!title.equals(driver.getTitle())) continue;
            return driver;
        }
        throw new NoSuchWindowException("Window with title not found: " + title);
    }

    private SelenideWait Wait() {
        return new SelenideWait(this.webDriver, this.config.timeout(), this.config.pollingInterval());
    }
}

