/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

public class Browser {
    public final String name;
    public final boolean headless;

    public Browser(String name, boolean headless) {
        this.name = name;
        this.headless = headless;
    }

    public boolean isHeadless() {
        return this.isHtmlUnit() || this.isPhantomjs() || this.headless;
    }

    public boolean isChrome() {
        return "chrome".equalsIgnoreCase(this.name);
    }

    public boolean isFirefox() {
        return "firefox".equalsIgnoreCase(this.name);
    }

    public boolean isLegacyFirefox() {
        return "legacy_firefox".equalsIgnoreCase(this.name);
    }

    public boolean isIE() {
        return "internet explorer".equalsIgnoreCase(this.name) || "ie".equalsIgnoreCase(this.name);
    }

    public boolean isEdge() {
        return "edge".equalsIgnoreCase(this.name);
    }

    public boolean isSafari() {
        return "safari".equalsIgnoreCase(this.name);
    }

    public boolean isHtmlUnit() {
        return this.name != null && this.name.startsWith("htmlunit");
    }

    public boolean isPhantomjs() {
        return "phantomjs".equalsIgnoreCase(this.name);
    }

    public boolean isOpera() {
        return "opera".equalsIgnoreCase(this.name);
    }

    public boolean isJBrowser() {
        return "jbrowser".equalsIgnoreCase(this.name);
    }

    public boolean supportsModalDialogs() {
        return !this.isPhantomjs() && !this.isSafari();
    }
}

