/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.localstorage;

import com.codeborne.selenide.LocalStorage;
import com.codeborne.selenide.ObjectCondition;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Item
implements ObjectCondition<LocalStorage> {
    private final String item;

    public Item(String item) {
        this.item = item;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String description() {
        return String.format("should have item '%s'", this.item);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String negativeDescription() {
        return String.format("should not have item '%s'", this.item);
    }

    @Override
    @Nullable
    @CheckReturnValue
    public String actualValue(LocalStorage localStorage) {
        return localStorage.getItems().toString();
    }

    @Override
    @Nullable
    @CheckReturnValue
    public String expectedValue() {
        return this.item;
    }

    @Override
    @CheckReturnValue
    public boolean test(LocalStorage localStorage) {
        return localStorage.containsItem(this.item);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String describe(LocalStorage localStorage) {
        return "localStorage";
    }
}

