/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public abstract class TextCondition
extends Condition {
    private final String expectedText;
    private final ThreadLocal<String> actualText = new ThreadLocal();

    protected TextCondition(String name, String expectedText) {
        super(name);
        this.expectedText = expectedText;
    }

    protected abstract boolean match(String var1, String var2);

    protected String getText(Driver driver, WebElement element) {
        return element.getText();
    }

    @Override
    public final boolean apply(Driver driver, WebElement element) {
        this.actualText.set(this.getText(driver, element));
        return this.match(this.actualText.get(), this.expectedText);
    }

    @Override
    @Nullable
    public final String actualValue(Driver driver, WebElement element) {
        return this.actualText.get();
    }

    @Override
    public final String toString() {
        return String.format("%s '%s'", this.getName(), this.expectedText);
    }
}

