/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.WebElementSource;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class IsDisplayed
implements Command<Boolean> {
    private static final Logger logger = LoggerFactory.getLogger(IsDisplayed.class);

    @Override
    @CheckReturnValue
    public Boolean execute(SelenideElement proxy, WebElementSource locator, @Nullable Object[] args) {
        try {
            WebElement element = locator.getWebElement();
            return this.isDisplayedPatched(element);
        }
        catch (ElementNotFound | WebDriverException elementNotFound) {
            if (Cleanup.of.isInvalidSelectorError((Throwable)elementNotFound)) {
                throw Cleanup.of.wrapInvalidSelectorException((Throwable)elementNotFound);
            }
            return false;
        }
        catch (IndexOutOfBoundsException invalidElementIndex) {
            return false;
        }
    }

    private boolean isDisplayedPatched(WebElement element) {
        try {
            return element.isDisplayed();
        }
        catch (NullPointerException e) {
            if (element instanceof RemoteWebElement) {
                logger.warn("NPE in RemoteWebElement.isDisplayed, see https://github.com/SeleniumHQ/selenium/issues/9266", (Throwable)e);
                return false;
            }
            throw e;
        }
    }
}

