/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.FileDownloadMode;
import com.codeborne.selenide.files.DownloadAction;
import com.codeborne.selenide.files.DownloadActions;
import com.codeborne.selenide.files.FileFilter;
import com.codeborne.selenide.files.FileFilters;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DownloadOptions {
    private static final long UNSPECIFIED_TIMEOUT = Long.MIN_VALUE;
    private final FileDownloadMode method;
    private final long timeout;
    private final FileFilter filter;
    private final DownloadAction action;

    private DownloadOptions(FileDownloadMode method, long timeout, FileFilter filter, DownloadAction action) {
        this.method = method;
        this.timeout = timeout;
        this.filter = filter;
        this.action = action;
    }

    @CheckReturnValue
    @Nonnull
    public FileDownloadMode getMethod() {
        return this.method;
    }

    @CheckReturnValue
    public long getTimeout(long defaultValue) {
        return this.hasSpecifiedTimed() ? this.timeout : defaultValue;
    }

    private boolean hasSpecifiedTimed() {
        return this.timeout != Long.MIN_VALUE;
    }

    @CheckReturnValue
    @Nonnull
    public FileFilter getFilter() {
        return this.filter;
    }

    @CheckReturnValue
    @Nonnull
    public DownloadAction getAction() {
        return this.action;
    }

    @CheckReturnValue
    @Nonnull
    public DownloadOptions withTimeout(long timeout) {
        return new DownloadOptions(this.method, timeout, this.filter, this.action);
    }

    @CheckReturnValue
    @Nonnull
    public DownloadOptions withFilter(FileFilter filter) {
        return new DownloadOptions(this.method, this.timeout, filter, this.action);
    }

    public DownloadOptions withAction(DownloadAction action) {
        return new DownloadOptions(this.method, this.timeout, this.filter, action);
    }

    public String toString() {
        if (this.hasSpecifiedTimed() && !this.filter.isEmpty()) {
            return String.format("method: %s, timeout: %s ms, filter: %s", new Object[]{this.method, this.timeout, this.filter.description()});
        }
        if (this.hasSpecifiedTimed()) {
            return String.format("method: %s, timeout: %s ms", new Object[]{this.method, this.timeout});
        }
        if (!this.filter.isEmpty()) {
            return String.format("method: %s, filter: %s", new Object[]{this.method, this.filter.description()});
        }
        return String.format("method: %s", new Object[]{this.method});
    }

    @CheckReturnValue
    @Nonnull
    public static DownloadOptions using(FileDownloadMode method) {
        return new DownloadOptions(method, Long.MIN_VALUE, FileFilters.none(), DownloadActions.click());
    }
}

